/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.util.Colour;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemDisk
extends Item
implements IMedia,
IColouredItem {
    private static final String NBT_ID = "DiskId";

    public ItemDisk(Item.Properties settings) {
        super(settings);
    }

    @Nonnull
    public static ItemStack createFromIDAndColour(int id, String label, int colour) {
        ItemStack stack = new ItemStack((IItemProvider)Registry.ModItems.DISK.get());
        ItemDisk.setDiskID(stack, id);
        ((ItemDisk)Registry.ModItems.DISK.get()).setLabel(stack, label);
        IColouredItem.setColourBasic(stack, colour);
        return stack;
    }

    public void func_150895_a(@Nonnull ItemGroup tabs, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        for (int colour = 0; colour < 16; ++colour) {
            list.add((Object)ItemDisk.createFromIDAndColour(-1, null, Colour.VALUES[colour].getHex()));
        }
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> list, ITooltipFlag options) {
        int id;
        if (options.func_194127_a() && (id = ItemDisk.getDiskID(stack)) >= 0) {
            list.add((ITextComponent)new TranslationTextComponent("gui.computercraft.tooltip.disk_id", new Object[]{id}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return stack.func_82837_s() ? stack.func_200301_q().getString() : null;
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(label));
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int diskID = ItemDisk.getDiskID(stack);
        if (diskID < 0) {
            diskID = ComputerCraftAPI.createUniqueNumberedSaveDir(world, "disk");
            ItemDisk.setDiskID(stack, diskID);
        }
        return ComputerCraftAPI.createSaveDirMount(world, "disk/" + diskID, ComputerCraft.floppySpaceLimit);
    }

    public static int getDiskID(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_ID) ? nbt.func_74762_e(NBT_ID) : -1;
    }

    private static void setDiskID(@Nonnull ItemStack stack, int id) {
        if (id >= 0) {
            stack.func_196082_o().func_74768_a(NBT_ID, id);
        }
    }

    @Override
    public int getColour(@Nonnull ItemStack stack) {
        int colour = IColouredItem.getColourBasic(stack);
        return colour == -1 ? Colour.WHITE.getHex() : colour;
    }
}

