/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public final class NetworkHandler {
    public static SimpleChannel network;

    private NetworkHandler() {
    }

    public static void setup() {
        String version = ComputerCraftAPI.getInstalledVersion();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("computercraft", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
        NetworkHandler.registerMainThread(0, NetworkDirection.PLAY_TO_SERVER, ComputerActionServerMessage::new);
        NetworkHandler.registerMainThread(1, NetworkDirection.PLAY_TO_SERVER, QueueEventServerMessage::new);
        NetworkHandler.registerMainThread(2, NetworkDirection.PLAY_TO_SERVER, RequestComputerMessage::new);
        NetworkHandler.registerMainThread(3, NetworkDirection.PLAY_TO_SERVER, KeyEventServerMessage::new);
        NetworkHandler.registerMainThread(4, NetworkDirection.PLAY_TO_SERVER, MouseEventServerMessage::new);
        NetworkHandler.registerMainThread(10, NetworkDirection.PLAY_TO_CLIENT, ChatTableClientMessage::new);
        NetworkHandler.registerMainThread(11, NetworkDirection.PLAY_TO_CLIENT, ComputerDataClientMessage::new);
        NetworkHandler.registerMainThread(12, NetworkDirection.PLAY_TO_CLIENT, ComputerDeletedClientMessage::new);
        NetworkHandler.registerMainThread(13, NetworkDirection.PLAY_TO_CLIENT, ComputerTerminalClientMessage::new);
        NetworkHandler.registerMainThread(14, NetworkDirection.PLAY_TO_CLIENT, PlayRecordClientMessage.class, PlayRecordClientMessage::new);
        NetworkHandler.registerMainThread(15, NetworkDirection.PLAY_TO_CLIENT, MonitorClientMessage.class, MonitorClientMessage::new);
    }

    public static void sendToPlayer(PlayerEntity player, NetworkMessage packet) {
        network.sendTo((Object)packet, ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllPlayers(NetworkMessage packet) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            NetworkHandler.sendToPlayer((PlayerEntity)player, packet);
        }
    }

    public static void sendToServer(NetworkMessage packet) {
        network.sendToServer((Object)packet);
    }

    public static void sendToAllAround(NetworkMessage packet, World world, Vector3d pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range, world.func_234923_W_());
        network.send(PacketDistributor.NEAR.with(() -> target), (Object)packet);
    }

    public static void sendToAllTracking(NetworkMessage packet, Chunk chunk) {
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)packet);
    }

    private static <T extends NetworkMessage> void registerMainThread(int id, NetworkDirection direction, Supplier<T> factory) {
        NetworkHandler.registerMainThread(id, direction, NetworkHandler.getType(factory), buf -> {
            NetworkMessage instance = (NetworkMessage)factory.get();
            instance.fromBytes((PacketBuffer)buf);
            return instance;
        });
    }

    private static <T extends NetworkMessage> void registerMainThread(int id, NetworkDirection direction, Class<T> type, Function<PacketBuffer, T> decoder) {
        network.messageBuilder(type, id, direction).encoder(NetworkMessage::toBytes).decoder(decoder).consumer((packet, contextSup) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSup.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }).add();
    }

    private static <T> Class<T> getType(Supplier<T> supplier) {
        return supplier.get().getClass();
    }
}

