/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.ClientTableFormatter;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.network.NetworkMessage;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class ChatTableClientMessage
implements NetworkMessage {
    private TableBuilder table;

    public ChatTableClientMessage(TableBuilder table) {
        if (table.getColumns() < 0) {
            throw new IllegalStateException("Cannot send an empty table");
        }
        this.table = table;
    }

    public ChatTableClientMessage() {
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.table.getId());
        buf.func_150787_b(this.table.getColumns());
        buf.writeBoolean(this.table.getHeaders() != null);
        if (this.table.getHeaders() != null) {
            for (ITextComponent header : this.table.getHeaders()) {
                buf.func_179256_a(header);
            }
        }
        buf.func_150787_b(this.table.getRows().size());
        Iterator<ITextComponent[]> iterator = this.table.getRows().iterator();
        while (iterator.hasNext()) {
            ITextComponent[] row;
            for (ITextComponent column : row = (ITextComponent[])iterator.next()) {
                buf.func_179256_a(column);
            }
        }
        buf.func_150787_b(this.table.getAdditional());
    }

    @Override
    public void fromBytes(@Nonnull PacketBuffer buf) {
        TableBuilder table;
        int i;
        int id = buf.func_150792_a();
        int columns = buf.func_150792_a();
        if (buf.readBoolean()) {
            ITextComponent[] headers = new ITextComponent[columns];
            for (i = 0; i < columns; ++i) {
                headers[i] = buf.func_179258_d();
            }
            table = new TableBuilder(id, headers);
        } else {
            table = new TableBuilder(id);
        }
        int rows = buf.func_150792_a();
        for (i = 0; i < rows; ++i) {
            ITextComponent[] row = new ITextComponent[columns];
            for (int j = 0; j < columns; ++j) {
                row[j] = buf.func_179258_d();
            }
            table.row(row);
        }
        table.setAdditional(buf.func_150792_a());
        this.table = table;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientTableFormatter.INSTANCE.display(this.table);
    }
}

