/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;

public class MouseEventServerMessage
extends ComputerServerMessage {
    public static final int TYPE_CLICK = 0;
    public static final int TYPE_DRAG = 1;
    public static final int TYPE_UP = 2;
    public static final int TYPE_SCROLL = 3;
    private int type;
    private int x;
    private int y;
    private int arg;

    public MouseEventServerMessage(int instanceId, int type, int arg, int x, int y) {
        super(instanceId);
        this.type = type;
        this.arg = arg;
        this.x = x;
        this.y = y;
    }

    public MouseEventServerMessage() {
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.type);
        buf.func_150787_b(this.arg);
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
    }

    @Override
    public void fromBytes(@Nonnull PacketBuffer buf) {
        super.fromBytes(buf);
        this.type = buf.readByte();
        this.arg = buf.func_150792_a();
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
    }

    @Override
    protected void handle(@Nonnull ServerComputer computer, @Nonnull IContainerComputer container) {
        InputState input = container.getInput();
        switch (this.type) {
            case 0: {
                input.mouseClick(this.arg, this.x, this.y);
                break;
            }
            case 1: {
                input.mouseDrag(this.arg, this.x, this.y);
                break;
            }
            case 2: {
                input.mouseUp(this.arg, this.x, this.y);
                break;
            }
            case 3: {
                input.mouseScroll(this.arg, this.x, this.y);
            }
        }
    }
}

