/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.asm.NamedMethod;
import dan200.computercraft.core.asm.PeripheralMethod;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class GenericPeripheralProvider {
    private static final ArrayList<Capability<?>> capabilities = new ArrayList();

    public static synchronized void addCapability(Capability<?> capability) {
        Objects.requireNonNull(capability, "Capability cannot be null");
        if (!capabilities.contains(capability)) {
            capabilities.add(capability);
        }
    }

    @Nullable
    public static IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side, NonNullConsumer<LazyOptional<IPeripheral>> invalidate) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        ArrayList<SaturatedMethod> saturated = new ArrayList<SaturatedMethod>(0);
        List<NamedMethod<PeripheralMethod>> tileMethods = PeripheralMethod.GENERATOR.getMethods(tile.getClass());
        if (!tileMethods.isEmpty()) {
            GenericPeripheralProvider.addSaturated(saturated, tile, tileMethods);
        }
        for (Capability<?> capability : capabilities) {
            LazyOptional wrapper = tile.getCapability(capability);
            wrapper.ifPresent(contents -> {
                List<NamedMethod<PeripheralMethod>> capabilityMethods = PeripheralMethod.GENERATOR.getMethods(contents.getClass());
                if (capabilityMethods.isEmpty()) {
                    return;
                }
                GenericPeripheralProvider.addSaturated(saturated, contents, capabilityMethods);
                wrapper.addListener(GenericPeripheralProvider.cast(invalidate));
            });
        }
        return saturated.isEmpty() ? null : new GenericPeripheral(tile, saturated);
    }

    private static void addSaturated(ArrayList<SaturatedMethod> saturated, Object target, List<NamedMethod<PeripheralMethod>> methods) {
        saturated.ensureCapacity(saturated.size() + methods.size());
        for (NamedMethod<PeripheralMethod> method : methods) {
            saturated.add(new SaturatedMethod(target, method));
        }
    }

    private static <T> NonNullConsumer<T> cast(NonNullConsumer<?> consumer) {
        return consumer;
    }
}

