/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;

public enum CableModemVariant implements IStringSerializable
{
    None("none", null),
    DownOff("down_off", Direction.DOWN),
    UpOff("up_off", Direction.UP),
    NorthOff("north_off", Direction.NORTH),
    SouthOff("south_off", Direction.SOUTH),
    WestOff("west_off", Direction.WEST),
    EastOff("east_off", Direction.EAST),
    DownOn("down_on", Direction.DOWN),
    UpOn("up_on", Direction.UP),
    NorthOn("north_on", Direction.NORTH),
    SouthOn("south_on", Direction.SOUTH),
    WestOn("west_on", Direction.WEST),
    EastOn("east_on", Direction.EAST),
    DownOffPeripheral("down_off_peripheral", Direction.DOWN),
    UpOffPeripheral("up_off_peripheral", Direction.UP),
    NorthOffPeripheral("north_off_peripheral", Direction.NORTH),
    SouthOffPeripheral("south_off_peripheral", Direction.SOUTH),
    WestOffPeripheral("west_off_peripheral", Direction.WEST),
    EastOffPeripheral("east_off_peripheral", Direction.EAST),
    DownOnPeripheral("down_on_peripheral", Direction.DOWN),
    UpOnPeripheral("up_on_peripheral", Direction.UP),
    NorthOnPeripheral("north_on_peripheral", Direction.NORTH),
    SouthOnPeripheral("south_on_peripheral", Direction.SOUTH),
    WestOnPeripheral("west_on_peripheral", Direction.WEST),
    EastOnPeripheral("east_on_peripheral", Direction.EAST);

    private static final CableModemVariant[] VALUES;
    private final String name;
    private final Direction facing;

    private CableModemVariant(String name, Direction facing) {
        this.name = name;
        this.facing = facing;
    }

    @Nonnull
    public static CableModemVariant from(Direction facing) {
        return facing == null ? None : VALUES[1 + facing.func_176745_a()];
    }

    @Nonnull
    public static CableModemVariant from(Direction facing, boolean modem, boolean peripheral) {
        int state = (modem ? 2 : 0) + (peripheral ? 1 : 0);
        return facing == null ? None : VALUES[1 + 6 * state + facing.func_176745_a()];
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Nullable
    public Direction getFacing() {
        return this.facing;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALUES = CableModemVariant.values();
    }
}

