/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.IDAssigner;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id;
    private String type;
    private IPeripheral peripheral;
    private final NonNullConsumer<LazyOptional<IPeripheral>> invalidate = x -> invalidate.run();

    public WiredModemLocalPeripheral(@Nonnull Runnable invalidate) {
    }

    public boolean attach(@Nonnull World world, @Nonnull BlockPos origin, @Nonnull Direction direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = IDAssigner.getNextId("peripheral." + type);
        }
        return oldPeripheral == null || !oldPeripheral.equals(peripheral);
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    @Nullable
    public String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    @Nullable
    public IPeripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(@Nonnull Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Collections.emptyMap() : Collections.singletonMap(this.type + "_" + this.id, this.peripheral);
    }

    public void write(@Nonnull CompoundNBT tag, @Nonnull String suffix) {
        if (this.id >= 0) {
            tag.func_74768_a(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.func_74778_a(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(@Nonnull CompoundNBT tag, @Nonnull String suffix) {
        this.id = tag.func_150297_b(NBT_PERIPHERAL_ID + suffix, 99) ? tag.func_74762_e(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.func_150297_b(NBT_PERIPHERAL_TYPE + suffix, 8) ? tag.func_74779_i(NBT_PERIPHERAL_TYPE + suffix) : null;
    }

    @Nullable
    private IPeripheral getPeripheralFrom(World world, BlockPos pos, Direction direction) {
        BlockPos offset = pos.func_177972_a(direction);
        Block block = world.func_180495_p(offset).func_177230_c();
        if (block == Registry.ModBlocks.WIRED_MODEM_FULL.get() || block == Registry.ModBlocks.CABLE.get()) {
            return null;
        }
        IPeripheral peripheral = Peripherals.getPeripheral(world, offset, direction.func_176734_d(), this.invalidate);
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }
}

