/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.collect.ImmutableMap;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.network.wired.IWiredSender;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IWorkMonitor;
import dan200.computercraft.core.apis.PeripheralAPI;
import dan200.computercraft.core.asm.PeripheralMethod;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;

public abstract class WiredModemPeripheral
extends ModemPeripheral
implements IWiredSender {
    private final WiredModemElement modem;
    private final Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> peripheralWrappers = new HashMap<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>>(1);

    public WiredModemPeripheral(ModemState state, WiredModemElement modem) {
        super(state);
        this.modem = modem;
    }

    @Override
    public boolean isInterdimensional() {
        return false;
    }

    @Override
    public double getRange() {
        return 256.0;
    }

    @Override
    protected IPacketNetwork getNetwork() {
        return this.modem.getNode();
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.modem.getWorld();
    }

    @Nonnull
    protected abstract WiredModemLocalPeripheral getLocalPeripheral();

    @LuaFunction
    public final Collection<String> getNamesRemote(IComputerAccess computer) {
        return this.getWrappers(computer).keySet();
    }

    @LuaFunction
    public final boolean isPresentRemote(IComputerAccess computer, String name) {
        return this.getWrapper(computer, name) != null;
    }

    @LuaFunction
    public final Object[] getTypeRemote(IComputerAccess computer, String name) {
        Object[] objectArray;
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, name);
        if (wrapper != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = wrapper.getType();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @LuaFunction
    public final Object[] getMethodsRemote(IComputerAccess computer, String name) {
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, name);
        if (wrapper == null) {
            return null;
        }
        return new Object[]{wrapper.getMethodNames()};
    }

    @LuaFunction
    public final MethodResult callRemote(IComputerAccess computer, ILuaContext context, IArguments arguments) throws LuaException {
        String remoteName = arguments.getString(0);
        String methodName = arguments.getString(1);
        RemotePeripheralWrapper wrapper = this.getWrapper(computer, remoteName);
        if (wrapper == null) {
            throw new LuaException("No peripheral: " + remoteName);
        }
        return wrapper.callMethod(context, methodName, arguments.drop(2));
    }

    @LuaFunction
    public final Object[] getNameLocal() {
        Object[] objectArray;
        String local = this.getLocalPeripheral().getConnectedName();
        if (local == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = local;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        ConcurrentMap<String, RemotePeripheralWrapper> wrappers;
        super.attach(computer);
        Map<Object, Object> map = this.peripheralWrappers;
        synchronized (map) {
            wrappers = this.peripheralWrappers.get(computer);
            if (wrappers == null) {
                wrappers = new ConcurrentHashMap<String, RemotePeripheralWrapper>();
                this.peripheralWrappers.put(computer, wrappers);
            }
        }
        map = this.modem.getRemotePeripherals();
        synchronized (map) {
            for (Map.Entry<String, IPeripheral> entry : this.modem.getRemotePeripherals().entrySet()) {
                this.attachPeripheralImpl(computer, wrappers, entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        Map wrappers;
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            wrappers = this.peripheralWrappers.remove(computer);
        }
        if (wrappers != null) {
            for (RemotePeripheralWrapper wrapper : wrappers.values()) {
                wrapper.detach();
            }
            wrappers.clear();
        }
        super.detach(computer);
    }

    @Override
    public boolean equals(IPeripheral other) {
        if (other instanceof WiredModemPeripheral) {
            WiredModemPeripheral otherModem = (WiredModemPeripheral)other;
            return otherModem.modem == this.modem;
        }
        return false;
    }

    @Override
    @Nonnull
    public IWiredNode getNode() {
        return this.modem.getNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachPeripheral(String name, IPeripheral peripheral) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            for (Map.Entry<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> entry : this.peripheralWrappers.entrySet()) {
                this.attachPeripheralImpl(entry.getKey(), entry.getValue(), name, peripheral);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachPeripheral(String name) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            for (ConcurrentMap<String, RemotePeripheralWrapper> wrappers : this.peripheralWrappers.values()) {
                RemotePeripheralWrapper wrapper = (RemotePeripheralWrapper)wrappers.remove(name);
                if (wrapper == null) continue;
                wrapper.detach();
            }
        }
    }

    private void attachPeripheralImpl(IComputerAccess computer, ConcurrentMap<String, RemotePeripheralWrapper> peripherals, String periphName, IPeripheral peripheral) {
        if (!peripherals.containsKey(periphName) && !periphName.equals(this.getLocalPeripheral().getConnectedName())) {
            RemotePeripheralWrapper wrapper = new RemotePeripheralWrapper(this.modem, peripheral, computer, periphName);
            peripherals.put(periphName, wrapper);
            wrapper.attach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, RemotePeripheralWrapper> getWrappers(IComputerAccess computer) {
        Map<IComputerAccess, ConcurrentMap<String, RemotePeripheralWrapper>> map = this.peripheralWrappers;
        synchronized (map) {
            return this.peripheralWrappers.get(computer);
        }
    }

    private RemotePeripheralWrapper getWrapper(IComputerAccess computer, String remoteName) {
        ConcurrentMap<String, RemotePeripheralWrapper> wrappers = this.getWrappers(computer);
        return wrappers == null ? null : (RemotePeripheralWrapper)wrappers.get(remoteName);
    }

    private static class RemotePeripheralWrapper
    implements IComputerAccess {
        private final WiredModemElement element;
        private final IPeripheral peripheral;
        private final IComputerAccess computer;
        private final String name;
        private final String type;
        private final Map<String, PeripheralMethod> methodMap;

        RemotePeripheralWrapper(WiredModemElement element, IPeripheral peripheral, IComputerAccess computer, String name) {
            this.element = element;
            this.peripheral = peripheral;
            this.computer = computer;
            this.name = name;
            this.type = Objects.requireNonNull(peripheral.getType(), "Peripheral type cannot be null");
            this.methodMap = PeripheralAPI.getMethods(peripheral);
        }

        public void attach() {
            this.peripheral.attach(this);
            this.computer.queueEvent("peripheral", this.getAttachmentName());
        }

        public void detach() {
            this.peripheral.detach(this);
            this.computer.queueEvent("peripheral_detach", this.getAttachmentName());
        }

        public String getType() {
            return this.type;
        }

        public Collection<String> getMethodNames() {
            return this.methodMap.keySet();
        }

        public MethodResult callMethod(ILuaContext context, String methodName, IArguments arguments) throws LuaException {
            PeripheralMethod method = this.methodMap.get(methodName);
            if (method == null) {
                throw new LuaException("No such method " + methodName);
            }
            return method.apply(this.peripheral, context, this, arguments);
        }

        @Override
        public String mount(@Nonnull String desiredLocation, @Nonnull IMount mount) {
            return this.computer.mount(desiredLocation, mount, this.name);
        }

        @Override
        public String mount(@Nonnull String desiredLocation, @Nonnull IMount mount, @Nonnull String driveName) {
            return this.computer.mount(desiredLocation, mount, driveName);
        }

        @Override
        public String mountWritable(@Nonnull String desiredLocation, @Nonnull IWritableMount mount) {
            return this.computer.mountWritable(desiredLocation, mount, this.name);
        }

        @Override
        public String mountWritable(@Nonnull String desiredLocation, @Nonnull IWritableMount mount, @Nonnull String driveName) {
            return this.computer.mountWritable(desiredLocation, mount, driveName);
        }

        @Override
        public void unmount(String location) {
            this.computer.unmount(location);
        }

        @Override
        public int getID() {
            return this.computer.getID();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... arguments) {
            this.computer.queueEvent(event, arguments);
        }

        @Override
        @Nonnull
        public IWorkMonitor getMainThreadMonitor() {
            return this.computer.getMainThreadMonitor();
        }

        @Override
        @Nonnull
        public String getAttachmentName() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public Map<String, IPeripheral> getAvailablePeripherals() {
            Map<String, IPeripheral> map = this.element.getRemotePeripherals();
            synchronized (map) {
                return ImmutableMap.copyOf(this.element.getRemotePeripherals());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public IPeripheral getAvailablePeripheral(@Nonnull String name) {
            Map<String, IPeripheral> map = this.element.getRemotePeripherals();
            synchronized (map) {
                return this.element.getRemotePeripherals().get(name);
            }
        }
    }
}

