/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class SpeakerPeripheral
implements IPeripheral {
    private long clock = 0L;
    private long lastPlayTime = 0L;
    private final AtomicInteger notesThisTick = new AtomicInteger();

    public void update() {
        ++this.clock;
        this.notesThisTick.set(0);
    }

    public abstract World getWorld();

    public abstract Vector3d getPosition();

    public boolean madeSound(long ticks) {
        return this.clock - this.lastPlayTime <= ticks;
    }

    @Override
    @Nonnull
    public String getType() {
        return "speaker";
    }

    @LuaFunction
    public final boolean playSound(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        ResourceLocation identifier;
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        try {
            identifier = new ResourceLocation(name);
        }
        catch (ResourceLocationException e) {
            throw new LuaException("Malformed sound name '" + name + "' ");
        }
        return this.playSound(context, identifier, volume, pitch, false);
    }

    @LuaFunction
    public final synchronized boolean playNote(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        NoteBlockInstrument instrument = null;
        for (NoteBlockInstrument testInstrument : NoteBlockInstrument.values()) {
            if (!testInstrument.func_176610_l().equalsIgnoreCase(name)) continue;
            instrument = testInstrument;
            break;
        }
        if (instrument == null) {
            throw new LuaException("Invalid instrument, \"" + name + "\"!");
        }
        boolean success = this.playSound(context, instrument.func_208088_a().getRegistryName(), volume, (float)Math.pow(2.0, ((double)pitch - 12.0) / 12.0), true);
        if (success) {
            this.notesThisTick.incrementAndGet();
        }
        return success;
    }

    private synchronized boolean playSound(ILuaContext context, ResourceLocation name, float volume, float pitch, boolean isNote) throws LuaException {
        if (!(this.clock - this.lastPlayTime >= 1L || isNote && this.clock - this.lastPlayTime == 0L && this.notesThisTick.get() < ComputerCraft.maxNotesPerTick)) {
            return false;
        }
        World world = this.getWorld();
        Vector3d pos = this.getPosition();
        context.issueMainThreadTask(() -> {
            MinecraftServer server = world.func_73046_m();
            if (server == null) {
                return null;
            }
            float adjVolume = Math.min(volume, 3.0f);
            server.func_184103_al().func_148543_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, adjVolume > 1.0f ? (double)(16.0f * adjVolume) : 16.0, world.func_234923_W_(), (IPacket)new SPlaySoundPacket(name, SoundCategory.RECORDS, pos, adjVolume, pitch));
            return null;
        });
        this.lastPlayTime = this.clock;
        return true;
    }
}

