/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.recipes;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class PocketComputerUpgradeRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<PocketComputerUpgradeRecipe> SERIALIZER = new SpecialRecipeSerializer(PocketComputerUpgradeRecipe::new);

    private PocketComputerUpgradeRecipe(ResourceLocation identifier) {
        super(identifier);
    }

    public boolean func_194133_a(int x, int y) {
        return x >= 2 && y >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.NORMAL, null);
    }

    public boolean matches(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return !this.assemble(inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inventory) {
        ItemStack computer = ItemStack.field_190927_a;
        int computerX = -1;
        int computerY = -1;
        block0: for (int y = 0; y < inventory.func_174923_h(); ++y) {
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack item = inventory.func_70301_a(x + y * inventory.func_174922_i());
                if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemPocketComputer)) continue;
                computer = item;
                computerX = x;
                computerY = y;
                break block0;
            }
        }
        if (computer.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemPocketComputer itemComputer = (ItemPocketComputer)computer.func_77973_b();
        if (ItemPocketComputer.getUpgrade(computer) != null) {
            return ItemStack.field_190927_a;
        }
        IPocketUpgrade upgrade = null;
        for (int y = 0; y < inventory.func_174923_h(); ++y) {
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack item = inventory.func_70301_a(x + y * inventory.func_174922_i());
                if (x == computerX && y == computerY || !(x == computerX && y == computerY - 1 ? (upgrade = PocketUpgrades.get(item)) == null : !item.func_190926_b())) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (upgrade == null) {
            return ItemStack.field_190927_a;
        }
        ComputerFamily family = itemComputer.getFamily();
        int computerID = itemComputer.getComputerID(computer);
        String label = itemComputer.getLabel(computer);
        int colour = itemComputer.getColour(computer);
        return PocketComputerItemFactory.create(computerID, label, colour, family, upgrade);
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

