/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.proxy;

import com.mojang.brigadier.CommandDispatcher;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.MainThread;
import dan200.computercraft.core.tracking.Tracking;
import dan200.computercraft.shared.command.CommandComputerCraft;
import dan200.computercraft.shared.command.arguments.ArgumentSerializers;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.peripheral.generic.methods.EnergyMethods;
import dan200.computercraft.shared.peripheral.generic.methods.FluidMethods;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.util.NullStorage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.items.CapabilityItemHandler;

@Mod.EventBusSubscriber(modid="computercraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ComputerCraftProxyCommon {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        NetworkHandler.setup();
        DeferredWorkQueue.runLater(() -> {
            ComputerCraftProxyCommon.registerProviders();
            ArgumentSerializers.register();
            ComputerCraftProxyCommon.registerLoot();
        });
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
        ComputerCraftAPI.registerGenericSource(new FluidMethods());
        ComputerCraftAPI.registerGenericSource(new EnergyMethods());
    }

    public static void registerLoot() {
        ComputerCraftProxyCommon.registerCondition("block_named", BlockNamedEntityLootCondition.TYPE);
        ComputerCraftProxyCommon.registerCondition("player_creative", PlayerCreativeLootCondition.TYPE);
        ComputerCraftProxyCommon.registerCondition("has_id", HasComputerIdLootCondition.TYPE);
    }

    private static void registerCondition(String name, LootConditionType serializer) {
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation("computercraft", name), (Object)serializer);
    }

    private static void registerProviders() {
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item item = stack.func_77973_b();
            if (item instanceof IMedia) {
                return (IMedia)item;
            }
            if (item instanceof MusicDiscItem) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        CapabilityManager.INSTANCE.register(IWiredElement.class, new NullStorage(), () -> null);
        CapabilityManager.INSTANCE.register(IPeripheral.class, new NullStorage(), () -> null);
        ComputerCraftAPI.registerGenericCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        ComputerCraftAPI.registerGenericCapability(CapabilityEnergy.ENERGY);
        ComputerCraftAPI.registerGenericCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Mod.EventBusSubscriber(modid="computercraft")
    public static final class ForgeHandlers {
        public static final ResourceLocation LOOT_TREASURE_DISK = new ResourceLocation("computercraft", "treasure_disk");
        private static final Set<ResourceLocation> TABLES = new HashSet<ResourceLocation>(Arrays.asList(LootTables.field_186422_d, LootTables.field_186424_f, LootTables.field_186428_j, LootTables.field_186427_i, LootTables.field_186426_h, LootTables.field_186429_k, LootTables.field_186430_l, LootTables.field_186431_m, LootTables.field_191192_o, LootTables.field_215817_h));

        private ForgeHandlers() {
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                MainThread.executePendingTasks();
                ComputerCraft.serverComputerRegistry.update();
            }
        }

        @SubscribeEvent
        public static void onContainerOpen(PlayerContainerEvent.Open event) {
            IComputer computer;
            Container container = event.getContainer();
            if (container instanceof IContainerComputer && (computer = ((IContainerComputer)container).getComputer()) instanceof ServerComputer) {
                ((ServerComputer)computer).sendTerminalState(event.getPlayer());
            }
        }

        @SubscribeEvent
        public static void onRegisterCommand(RegisterCommandsEvent event) {
            CommandComputerCraft.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onServerStarted(FMLServerStartedEvent event) {
            ComputerCraft.serverComputerRegistry.reset();
            WirelessNetwork.resetNetworks();
            Tracking.reset();
        }

        @SubscribeEvent
        public static void onServerStopped(FMLServerStoppedEvent event) {
            ComputerCraft.serverComputerRegistry.reset();
            WirelessNetwork.resetNetworks();
            Tracking.reset();
        }

        @SubscribeEvent
        public static void lootLoad(LootTableLoadEvent event) {
            ResourceLocation name = event.getName();
            if (!name.func_110624_b().equals("minecraft") || !TABLES.contains(name)) {
                return;
            }
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)LOOT_TREASURE_DISK)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).name("computercraft_treasure").func_216044_b());
        }
    }
}

