/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleInventoryEvent;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class TurtleDropCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack stack = InventoryUtil.takeItems(this.quantity, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to drop");
        }
        World world = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.func_177972_a(direction);
        Direction side = direction.func_176734_d();
        IItemHandler inventory = InventoryUtil.getInventory(world, newPosition, side);
        TurtlePlayer player = TurtlePlaceCommand.createPlayer(turtle, oldPosition, direction);
        TurtleInventoryEvent.Drop event = new TurtleInventoryEvent.Drop(turtle, player, world, newPosition, inventory, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            InventoryUtil.storeItems(stack, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (inventory != null) {
            ItemStack remainder = InventoryUtil.storeItems(stack, inventory);
            if (!remainder.func_190926_b()) {
                InventoryUtil.storeItems(remainder, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        WorldUtil.dropItemStack(stack, world, oldPosition, direction);
        world.func_175669_a(1000, newPosition, 0);
        turtle.playAnimation(TurtleAnimation.WAIT);
        return TurtleCommandResult.success();
    }
}

