/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TurtleMoveCommand
implements ITurtleCommand {
    private final MoveDirection direction;
    private static final AxisAlignedBB EMPTY_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleBlockEvent.Move moveEvent;
        Direction direction = this.direction.toWorldDir(turtle);
        World oldWorld = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = oldPosition.func_177972_a(direction);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(turtlePlayer, oldWorld, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        BlockState state = oldWorld.func_180495_p(newPosition);
        if (!(oldWorld.func_175623_d(newPosition) || WorldUtil.isLiquidBlock(oldWorld, newPosition) || state.func_185904_a().func_76222_j())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        VoxelShape collision = state.func_196952_d((IBlockReader)oldWorld, oldPosition).func_197751_a((double)newPosition.func_177958_n(), (double)newPosition.func_177956_o(), (double)newPosition.func_177952_p());
        if (!oldWorld.func_195585_a(null, collision)) {
            if (!ComputerCraft.turtlesCanPush || this.direction == MoveDirection.UP || this.direction == MoveDirection.DOWN) {
                return TurtleCommandResult.failure("Movement obstructed");
            }
            List list = oldWorld.func_175647_a(Entity.class, TurtleMoveCommand.getBox(collision), x -> x != null && x.func_70089_S() && x.field_70156_m);
            for (Entity entity : list) {
                AxisAlignedBB pushedBB = entity.func_174813_aQ().func_72317_d((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e());
                if (oldWorld.func_195585_a(null, VoxelShapes.func_197881_a((AxisAlignedBB)pushedBB))) continue;
                return TurtleCommandResult.failure("Movement obstructed");
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(moveEvent = new TurtleBlockEvent.Move(turtle, turtlePlayer, oldWorld, newPosition)))) {
            return TurtleCommandResult.failure(moveEvent.getFailureMessage());
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo(oldWorld, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            default: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }

    private static TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, World world, BlockPos position) {
        if (World.func_189509_E((BlockPos)position)) {
            return TurtleCommandResult.failure(position.func_177956_o() < 0 ? "Too low to move" : "Too high to move");
        }
        if (!World.func_175701_a((BlockPos)position)) {
            return TurtleCommandResult.failure("Cannot leave the world");
        }
        if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEnterable(world, position, (PlayerEntity)turtlePlayer)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.isAreaLoaded(position, 0)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        if (!world.func_175723_af().func_177746_a(position)) {
            return TurtleCommandResult.failure("Cannot pass the world border");
        }
        return TurtleCommandResult.success();
    }

    private static AxisAlignedBB getBox(VoxelShape shape) {
        return shape.func_197766_b() ? EMPTY_BOX : shape.func_197752_a();
    }
}

