/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BoatItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.LilyPadItem;
import net.minecraft.item.SignItem;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().func_70301_a(turtle.getSelectedSlot());
        if (stack.func_190926_b()) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos coordinates = turtle.getPosition().func_177972_a(direction);
        BlockPos playerPosition = turtle.getPosition().func_177972_a(direction);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, playerPosition, direction);
        TurtleBlockEvent.Place place = new TurtleBlockEvent.Place(turtle, turtlePlayer, turtle.getWorld(), coordinates, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)place)) {
            return TurtleCommandResult.failure(place.getFailureMessage());
        }
        String[] errorMessage = new String[1];
        ItemStack remainder = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, errorMessage);
        if (remainder != stack) {
            turtle.getInventory().func_70299_a(turtle.getSelectedSlot(), remainder);
            turtle.getInventory().func_70296_d();
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (errorMessage[0] != null) {
            return TurtleCommandResult.failure(errorMessage[0]);
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            return TurtleCommandResult.failure("Cannot place block here");
        }
        return TurtleCommandResult.failure("Cannot place item here");
    }

    public static ItemStack deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, Direction direction, Object[] extraArguments, String[] outErrorMessage) {
        BlockPos playerPosition = turtle.getPosition().func_177972_a(direction);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, playerPosition, direction);
        return TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, extraArguments, outErrorMessage);
    }

    public static ItemStack deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, Object[] extraArguments, String[] outErrorMessage) {
        ItemStack remainder = TurtlePlaceCommand.deployOnEntity(stack, turtle, turtlePlayer, direction, extraArguments, outErrorMessage);
        if (remainder != stack) {
            return remainder;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = position.func_177972_a(direction);
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.func_176734_d(), extraArguments, true, outErrorMessage);
        if (remainder != stack) {
            return remainder;
        }
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.func_177972_a(direction), direction.func_176734_d(), extraArguments, false, outErrorMessage);
        if (remainder != stack) {
            return remainder;
        }
        if (direction.func_176740_k() != Direction.Axis.Y && (remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.func_177977_b(), Direction.UP, extraArguments, false, outErrorMessage)) != stack) {
            return remainder;
        }
        remainder = TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
        if (remainder != stack) {
            return remainder;
        }
        return stack;
    }

    public static TurtlePlayer createPlayer(ITurtleAccess turtle, BlockPos position, Direction direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        TurtlePlaceCommand.orientPlayer(turtle, turtlePlayer, position, direction);
        return turtlePlayer;
    }

    private static void orientPlayer(ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction direction) {
        double posX = (double)position.func_177958_n() + 0.5;
        double posY = (double)position.func_177956_o() + 0.5;
        double posZ = (double)position.func_177952_p() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.func_82601_c();
            posY += 0.48 * (double)direction.func_96559_d();
            posZ += 0.48 * (double)direction.func_82599_e();
        }
        if (direction.func_176740_k() != Direction.Axis.Y) {
            turtlePlayer.field_70177_z = direction.func_185119_l();
            turtlePlayer.field_70125_A = 0.0f;
        } else {
            turtlePlayer.field_70177_z = turtle.getDirection().func_185119_l();
            turtlePlayer.field_70125_A = DirectionUtil.toPitchAngle(direction);
        }
        turtlePlayer.func_226288_n_(posX, posY, posZ);
        turtlePlayer.field_70169_q = posX;
        turtlePlayer.field_70167_r = posY;
        turtlePlayer.field_70166_s = posZ;
        turtlePlayer.field_70127_C = turtlePlayer.field_70125_A;
        turtlePlayer.field_70126_B = turtlePlayer.field_70177_z;
        turtlePlayer.field_70758_at = turtlePlayer.field_70759_as = turtlePlayer.field_70177_z;
    }

    @Nonnull
    private static ItemStack deployOnEntity(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, Object[] extraArguments, String[] outErrorMessage) {
        Vector3d rayDir;
        World world = turtle.getWorld();
        BlockPos position = turtle.getPosition();
        Vector3d turtlePos = turtlePlayer.func_213303_ch();
        Pair<Entity, Vector3d> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.func_70676_i(1.0f), 1.5);
        if (hit == null) {
            return stack;
        }
        ItemStack stackCopy = stack.func_77946_l();
        turtlePlayer.loadInventory(stackCopy);
        Entity hitEntity = (Entity)hit.getKey();
        Vector3d hitPos = (Vector3d)hit.getValue();
        DropConsumer.set(hitEntity, drop -> InventoryUtil.storeItems(drop, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot()));
        boolean placed = false;
        ActionResultType cancelResult = ForgeHooks.onInteractEntityAt((PlayerEntity)turtlePlayer, (Entity)hitEntity, (Vector3d)hitPos, (Hand)Hand.MAIN_HAND);
        if (cancelResult == null) {
            cancelResult = hitEntity.func_184199_a((PlayerEntity)turtlePlayer, hitPos, Hand.MAIN_HAND);
        }
        if (cancelResult.func_226246_a_()) {
            placed = true;
        } else {
            cancelResult = ForgeHooks.onInteractEntity((PlayerEntity)turtlePlayer, (Entity)hitEntity, (Hand)Hand.MAIN_HAND);
            if (cancelResult != null && cancelResult.func_226246_a_()) {
                placed = true;
            } else if (cancelResult == null) {
                if (hitEntity.func_184230_a((PlayerEntity)turtlePlayer, Hand.MAIN_HAND) == ActionResultType.CONSUME) {
                    placed = true;
                } else if (hitEntity instanceof LivingEntity && (placed = stackCopy.func_111282_a_((PlayerEntity)turtlePlayer, (LivingEntity)hitEntity, Hand.MAIN_HAND).func_226246_a_())) {
                    turtlePlayer.loadInventory(stackCopy);
                }
            }
        }
        List<ItemStack> remainingDrops = DropConsumer.clear();
        for (ItemStack remaining : remainingDrops) {
            WorldUtil.dropItemStack(remaining, world, position, turtle.getDirection().func_176734_d());
        }
        ItemStack remainder = turtlePlayer.unloadInventory(turtle);
        if (!placed && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)remainder)) {
            return stack;
        }
        if (!remainder.func_190926_b()) {
            return remainder;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean canDeployOnBlock(@Nonnull BlockItemUseContext context, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, Direction side, boolean allowReplaceable, String[] outErrorMessage) {
        World world = turtle.getWorld();
        if (!World.func_175701_a((BlockPos)position) || world.func_175623_d(position) || context.func_195996_i().func_77973_b() instanceof BlockItem && WorldUtil.isLiquidBlock(world, position)) {
            return false;
        }
        BlockState state = world.func_180495_p(position);
        boolean replaceable = state.func_196953_a(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        if (ComputerCraft.turtlesObeyBlockProtection) {
            boolean editable;
            boolean bl = editable = replaceable ? TurtlePermissions.isBlockEditable(world, position, (PlayerEntity)player) : TurtlePermissions.isBlockEditable(world, position.func_177972_a(side), (PlayerEntity)player);
            if (!editable) {
                if (outErrorMessage != null) {
                    outErrorMessage[0] = "Cannot place in protected area";
                }
                return false;
            }
        }
        return true;
    }

    @Nonnull
    private static ItemStack deployOnBlock(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction side, Object[] extraArguments, boolean allowReplace, String[] outErrorMessage) {
        BlockRayTraceResult hit;
        ItemUseContext context;
        Direction playerDir = side.func_176734_d();
        BlockPos playerPosition = position.func_177972_a(side);
        TurtlePlaceCommand.orientPlayer(turtle, turtlePlayer, playerPosition, playerDir);
        ItemStack stackCopy = stack.func_77946_l();
        turtlePlayer.loadInventory(stackCopy);
        float hitX = 0.5f + (float)side.func_82601_c() * 0.5f;
        float hitY = 0.5f + (float)side.func_96559_d() * 0.5f;
        float hitZ = 0.5f + (float)side.func_82599_e() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        if (!TurtlePlaceCommand.canDeployOnBlock(new BlockItemUseContext(context = new ItemUseContext((PlayerEntity)turtlePlayer, Hand.MAIN_HAND, hit = new BlockRayTraceResult(new Vector3d((double)hitX, (double)hitY, (double)hitZ), side, position, false))), turtle, turtlePlayer, position, side, allowReplace, outErrorMessage)) {
            return stack;
        }
        Item item = stack.func_77973_b();
        boolean placed = false;
        TileEntity existingTile = turtle.getWorld().func_175625_s(position);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((PlayerEntity)turtlePlayer, (Hand)Hand.MAIN_HAND, (BlockPos)position, (BlockRayTraceResult)hit);
        if (!event.isCanceled()) {
            if (item.onItemUseFirst(stack, context).func_226246_a_()) {
                placed = true;
                turtlePlayer.loadInventory(stackCopy);
            } else if (event.getUseItem() != Event.Result.DENY && stackCopy.func_196084_a(context).func_226246_a_()) {
                placed = true;
                turtlePlayer.loadInventory(stackCopy);
            }
        }
        if (!placed && (item instanceof BucketItem || item instanceof BoatItem || item instanceof LilyPadItem || item instanceof GlassBottleItem)) {
            ActionResult result;
            ActionResultType actionResult = ForgeHooks.onItemRightClick((PlayerEntity)turtlePlayer, (Hand)Hand.MAIN_HAND);
            if (actionResult != null && actionResult.func_226246_a_()) {
                placed = true;
            } else if (actionResult == null && (result = stackCopy.func_77957_a(turtle.getWorld(), (PlayerEntity)turtlePlayer, Hand.MAIN_HAND)).func_188397_a().func_226246_a_() && !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)result.func_188398_b()))) {
                placed = true;
                turtlePlayer.loadInventory((ItemStack)result.func_188398_b());
            }
        }
        if (placed && item instanceof SignItem && extraArguments != null && extraArguments.length >= 1 && extraArguments[0] instanceof String) {
            World world = turtle.getWorld();
            TileEntity tile = world.func_175625_s(position);
            if (tile == null || tile == existingTile) {
                tile = world.func_175625_s(position.func_177972_a(side));
            }
            if (tile instanceof SignTileEntity) {
                SignTileEntity signTile = (SignTileEntity)tile;
                String s = (String)extraArguments[0];
                String[] split = s.split("\n");
                int firstLine = split.length <= 2 ? 1 : 0;
                for (int i = 0; i < 4; ++i) {
                    if (i >= firstLine && i < firstLine + split.length) {
                        if (split[i - firstLine].length() > 15) {
                            signTile.func_212365_a(i, (ITextComponent)new StringTextComponent(split[i - firstLine].substring(0, 15)));
                            continue;
                        }
                        signTile.func_212365_a(i, (ITextComponent)new StringTextComponent(split[i - firstLine]));
                        continue;
                    }
                    signTile.func_212365_a(i, (ITextComponent)new StringTextComponent(""));
                }
                signTile.func_70296_d();
                world.func_184138_a(tile.func_174877_v(), tile.func_195044_w(), tile.func_195044_w(), 3);
            }
        }
        ItemStack remainder = turtlePlayer.unloadInventory(turtle);
        if (!placed && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)remainder)) {
            return stack;
        }
        if (!remainder.func_190926_b()) {
            return remainder;
        }
        return ItemStack.field_190927_a;
    }
}

