/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;

public class ContainerTurtle
extends ContainerComputerBase {
    public static final int PLAYER_START_Y = 134;
    public static final int TURTLE_START_X = 175;
    private final IIntArray properties;

    private ContainerTurtle(int id, Predicate<PlayerEntity> canUse, IComputer computer, ComputerFamily family, PlayerInventory playerInventory, IInventory inventory, IIntArray properties) {
        super((ContainerType<? extends ContainerComputerBase>)((ContainerType)Registry.ModContainers.TURTLE.get()), id, canUse, computer, family);
        int x;
        int y;
        this.properties = properties;
        this.func_216961_a(properties);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.func_75146_a(new Slot(inventory, x + y * 4, 176 + x * 18, 135 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 135 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x2, 8 + x2 * 18, 193));
        }
    }

    public ContainerTurtle(int id, PlayerInventory player, TurtleBrain turtle) {
        this(id, p -> turtle.getOwner().func_70300_a((PlayerEntity)p), turtle.getOwner().createServerComputer(), turtle.getFamily(), player, turtle.getInventory(), turtle::getSelectedSlot);
    }

    public ContainerTurtle(int id, PlayerInventory player, ComputerContainerData data) {
        this(id, x -> true, ContainerTurtle.getComputer(player, data), data.getFamily(), player, (IInventory)new Inventory(16), (IIntArray)new IntArray(1));
    }

    public int getSelectedSlot() {
        return this.properties.func_221476_a(0);
    }

    @Nonnull
    private ItemStack tryItemMerge(PlayerEntity player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        ItemStack originalStack = ItemStack.field_190927_a;
        if (slot != null && slot.func_75216_d()) {
            ItemStack clickedStack = slot.func_75211_c();
            originalStack = clickedStack.func_77946_l();
            if (!this.func_75135_a(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.field_190927_a;
            }
            if (clickedStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (clickedStack.func_190916_E() != originalStack.func_190916_E()) {
                slot.func_190901_a(player, clickedStack);
            } else {
                return ItemStack.field_190927_a;
            }
        }
        return originalStack;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotNum) {
        if (slotNum >= 0 && slotNum < 16) {
            return this.tryItemMerge(player, slotNum, 16, 52, true);
        }
        if (slotNum >= 16) {
            return this.tryItemMerge(player, slotNum, 0, 16, false);
        }
        return ItemStack.field_190927_a;
    }
}

