/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ItemTurtle
extends ItemComputerBase
implements ITurtleItem {
    public ItemTurtle(BlockTurtle block, Item.Properties settings) {
        super(block, settings);
    }

    public ItemStack create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        ItemStack stack = new ItemStack((IItemProvider)this);
        if (label != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(label));
        }
        if (id >= 0) {
            stack.func_196082_o().func_74768_a("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            stack.func_196082_o().func_74768_a("Fuel", fuelLevel);
        }
        if (overlay != null) {
            stack.func_196082_o().func_74778_a("Overlay", overlay.toString());
        }
        if (leftUpgrade != null) {
            stack.func_196082_o().func_74778_a("LeftUpgrade", leftUpgrade.getUpgradeID().toString());
        }
        if (rightUpgrade != null) {
            stack.func_196082_o().func_74778_a("RightUpgrade", rightUpgrade.getUpgradeID().toString());
        }
        return stack;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ComputerFamily family = this.getFamily();
        list.add((Object)this.create(-1, null, -1, null, null, 0, null));
        TurtleUpgrades.getVanillaUpgrades().filter(x -> TurtleUpgrades.suitableForFamily(family, x)).map(x -> this.create(-1, null, -1, null, (ITurtleUpgrade)x, 0, null)).forEach(arg_0 -> list.add(arg_0));
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return new TranslationTextComponent(baseString + ".upgraded_twice", new Object[]{new TranslationTextComponent(right.getUnlocalisedAdjective()), new TranslationTextComponent(left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return new TranslationTextComponent(baseString + ".upgraded", new Object[]{new TranslationTextComponent(left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return new TranslationTextComponent(baseString + ".upgraded", new Object[]{new TranslationTextComponent(right.getUnlocalisedAdjective())});
        }
        return new TranslationTextComponent(baseString);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        String mod2;
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        if (left != null && (mod2 = TurtleUpgrades.getOwner(left)) != null && !mod2.equals("computercraft")) {
            return mod2;
        }
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (right != null && (mod = TurtleUpgrades.getOwner(right)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return super.getCreatorModId(stack);
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return TurtleItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, this.getUpgrade(stack, TurtleSide.LEFT), this.getUpgrade(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull ItemStack stack, @Nonnull TurtleSide side) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        String key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        return tag.func_74764_b(key) ? TurtleUpgrades.get(tag.func_74779_i(key)) : null;
    }

    @Override
    public ResourceLocation getOverlay(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("Overlay") ? new ResourceLocation(tag.func_74779_i("Overlay")) : null;
    }

    @Override
    public int getFuelLevel(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("Fuel") ? tag.func_74762_e("Fuel") : 0;
    }
}

