/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public final class TurtleUpgradeRecipe
extends SpecialRecipe {
    public static final IRecipeSerializer<TurtleUpgradeRecipe> SERIALIZER = new SpecialRecipeSerializer(TurtleUpgradeRecipe::new);

    private TurtleUpgradeRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean func_194133_a(int x, int y) {
        return x >= 3 && y >= 1;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return TurtleItemFactory.create(-1, null, -1, ComputerFamily.NORMAL, null, null, 0, null);
    }

    public boolean matches(@Nonnull CraftingInventory inventory, @Nonnull World world) {
        return !this.assemble(inventory).func_190926_b();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInventory inventory) {
        ItemStack leftItem = ItemStack.field_190927_a;
        ItemStack turtle = ItemStack.field_190927_a;
        ItemStack rightItem = ItemStack.field_190927_a;
        for (int y = 0; y < inventory.func_174923_h(); ++y) {
            if (turtle.func_190926_b()) {
                boolean finishedRow = false;
                for (int x = 0; x < inventory.func_174922_i(); ++x) {
                    ItemStack item = inventory.func_70301_a(x + y * inventory.func_174922_i());
                    if (!item.func_190926_b()) {
                        if (finishedRow) {
                            return ItemStack.field_190927_a;
                        }
                        if (item.func_77973_b() instanceof ITurtleItem) {
                            if (turtle.func_190926_b()) {
                                turtle = item;
                                continue;
                            }
                            return ItemStack.field_190927_a;
                        }
                        if (turtle.func_190926_b() && leftItem.func_190926_b()) {
                            leftItem = item;
                            continue;
                        }
                        if (!turtle.func_190926_b() && rightItem.func_190926_b()) {
                            rightItem = item;
                            continue;
                        }
                        return ItemStack.field_190927_a;
                    }
                    if (leftItem.func_190926_b() && turtle.func_190926_b()) continue;
                    finishedRow = true;
                }
                if (!turtle.func_190926_b() || leftItem.func_190926_b() && rightItem.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack item = inventory.func_70301_a(x + y * inventory.func_174922_i());
                if (item.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            }
        }
        if (turtle.func_190926_b() || leftItem.func_190926_b() && rightItem.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ITurtleItem itemTurtle = (ITurtleItem)turtle.func_77973_b();
        ComputerFamily family = itemTurtle.getFamily();
        ITurtleUpgrade[] upgrades = new ITurtleUpgrade[]{itemTurtle.getUpgrade(turtle, TurtleSide.LEFT), itemTurtle.getUpgrade(turtle, TurtleSide.RIGHT)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i].func_190926_b()) continue;
            ITurtleUpgrade itemUpgrade = TurtleUpgrades.get(items[i]);
            if (itemUpgrade == null) {
                return ItemStack.field_190927_a;
            }
            if (upgrades[i] != null) {
                return ItemStack.field_190927_a;
            }
            if (!TurtleUpgrades.suitableForFamily(family, itemUpgrade)) {
                return ItemStack.field_190927_a;
            }
            upgrades[i] = itemUpgrade;
        }
        int computerID = itemTurtle.getComputerID(turtle);
        String label = itemTurtle.getLabel(turtle);
        int fuelLevel = itemTurtle.getFuelLevel(turtle);
        int colour = itemTurtle.getColour(turtle);
        ResourceLocation overlay = itemTurtle.getOverlay(turtle);
        return TurtleItemFactory.create(computerID, label, colour, family, upgrades[0], upgrades[1], fuelLevel, overlay);
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

