/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPeripheral;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurtleSpeaker
extends AbstractTurtleUpgrade {
    private static final ModelResourceLocation leftModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_left", "inventory");
    private static final ModelResourceLocation rightModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_right", "inventory");

    public TurtleSpeaker(ResourceLocation id) {
        super(id, TurtleUpgradeType.PERIPHERAL, (Supplier<? extends IItemProvider>)Registry.ModBlocks.SPEAKER);
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return TransformedModel.of(side == TurtleSide.LEFT ? leftModel : rightModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide turtleSide) {
        IPeripheral turtlePeripheral = turtle.getPeripheral(turtleSide);
        if (turtlePeripheral instanceof Peripheral) {
            ((Peripheral)turtlePeripheral).update();
        }
    }

    private static class Peripheral
    extends SpeakerPeripheral {
        ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        public Vector3d getPosition() {
            BlockPos pos = this.turtle.getPosition();
            return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && this.turtle == ((Peripheral)other).turtle;
        }
    }
}

