/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.turtle.event.TurtleAttackEvent;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleTool
extends AbstractTurtleUpgrade {
    protected final ItemStack item;

    public TurtleTool(ResourceLocation id, String adjective, Item item) {
        super(id, TurtleUpgradeType.TOOL, adjective, (IItemProvider)item);
        this.item = new ItemStack((IItemProvider)item);
    }

    public TurtleTool(ResourceLocation id, Item item) {
        super(id, TurtleUpgradeType.TOOL, (IItemProvider)item);
        this.item = new ItemStack((IItemProvider)item);
    }

    public TurtleTool(ResourceLocation id, ItemStack craftItem, ItemStack toolItem) {
        super(id, TurtleUpgradeType.TOOL, craftItem);
        this.item = toolItem;
    }

    @Override
    public boolean isItemSuitable(@Nonnull ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || tag.isEmpty()) {
            return true;
        }
        if (stack.func_77951_h() || stack.func_77948_v() || stack.func_82837_s()) {
            return false;
        }
        return !tag.func_150297_b("AttributeModifiers", 9) || tag.func_150295_c("AttributeModifiers", 10).isEmpty();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        float xOffset = side == TurtleSide.LEFT ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(new float[]{0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        return TransformedModel.of(this.getCraftingItem(), new TransformationMatrix(transform));
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction direction) {
        switch (verb) {
            case ATTACK: {
                return this.attack(turtle, direction, side);
            }
            case DIG: {
                return this.dig(turtle, direction, side);
            }
        }
        return TurtleCommandResult.failure("Unsupported action");
    }

    protected boolean canBreakBlock(BlockState state, World world, BlockPos pos, TurtlePlayer player) {
        Block block = state.func_177230_c();
        return !state.func_196958_f() && block != Blocks.field_150357_h && state.func_185903_a((PlayerEntity)player, (IBlockReader)world, pos) > 0.0f && block.canEntityDestroy(state, (IBlockReader)world, pos, (Entity)player);
    }

    protected float getDamageMultiplier() {
        return 3.0f;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, Direction direction, TurtleSide side) {
        Vector3d rayDir;
        TileTurtle turtleTile;
        World world = turtle.getWorld();
        BlockPos position = turtle.getPosition();
        TileTurtle tileTurtle = turtleTile = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.func_175625_s(position);
        if (turtleTile == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, position, direction);
        Vector3d turtlePos = turtlePlayer.func_213303_ch();
        Pair<Entity, Vector3d> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.func_70676_i(1.0f), 1.5);
        if (hit != null) {
            ItemStack stackCopy = this.item.func_77946_l();
            turtlePlayer.loadInventory(stackCopy);
            Entity hitEntity = (Entity)hit.getKey();
            if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((PlayerEntity)turtlePlayer, hitEntity)) || !hitEntity.func_70075_an()) {
                return TurtleCommandResult.failure("Nothing to attack here");
            }
            TurtleAttackEvent attackEvent = new TurtleAttackEvent(turtle, turtlePlayer, hitEntity, this, side);
            if (MinecraftForge.EVENT_BUS.post((Event)attackEvent)) {
                return TurtleCommandResult.failure(attackEvent.getFailureMessage());
            }
            DropConsumer.set(hitEntity, TurtleTool.turtleDropConsumer(turtleTile, turtle));
            boolean attacked = false;
            if (!hitEntity.func_85031_j((Entity)turtlePlayer)) {
                float damage = (float)turtlePlayer.func_233637_b_(Attributes.field_233823_f_);
                if ((damage *= this.getDamageMultiplier()) > 0.0f) {
                    DamageSource source = DamageSource.func_76365_a((PlayerEntity)turtlePlayer);
                    if (hitEntity instanceof ArmorStandEntity) {
                        hitEntity.func_70097_a(source, damage);
                        if (hitEntity.func_70089_S()) {
                            hitEntity.func_70097_a(source, damage);
                        }
                        attacked = true;
                    } else if (hitEntity.func_70097_a(source, damage)) {
                        attacked = true;
                    }
                }
            }
            TurtleTool.stopConsuming(turtleTile, turtle);
            if (attacked) {
                turtlePlayer.unloadInventory(turtle);
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Nothing to attack here");
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, Direction direction, TurtleSide side) {
        TileTurtle turtleTile;
        World world = turtle.getWorld();
        BlockPos turtlePosition = turtle.getPosition();
        TileTurtle tileTurtle = turtleTile = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.func_175625_s(turtlePosition);
        if (turtleTile == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        BlockPos blockPosition = turtlePosition.func_177972_a(direction);
        if (world.func_175623_d(blockPosition) || WorldUtil.isLiquidBlock(world, blockPosition)) {
            return TurtleCommandResult.failure("Nothing to dig here");
        }
        BlockState state = world.func_180495_p(blockPosition);
        FluidState fluidState = world.func_204610_c(blockPosition);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, turtlePosition, direction);
        turtlePlayer.loadInventory(this.item.func_77946_l());
        if (ComputerCraft.turtlesObeyBlockProtection) {
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, blockPosition, state, (PlayerEntity)turtlePlayer))) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
            if (!TurtlePermissions.isBlockEditable(world, blockPosition, (PlayerEntity)turtlePlayer)) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
        }
        if (!this.canBreakBlock(state, world, blockPosition, turtlePlayer)) {
            return TurtleCommandResult.failure("Unbreakable block detected");
        }
        TurtleBlockEvent.Dig digEvent = new TurtleBlockEvent.Dig(turtle, turtlePlayer, world, blockPosition, state, this, side);
        if (MinecraftForge.EVENT_BUS.post((Event)digEvent)) {
            return TurtleCommandResult.failure(digEvent.getFailureMessage());
        }
        DropConsumer.set(world, blockPosition, TurtleTool.turtleDropConsumer(turtleTile, turtle));
        TileEntity tile = world.func_175625_s(blockPosition);
        world.func_217379_c(2001, blockPosition, Block.func_196246_j((BlockState)state));
        boolean canHarvest = state.canHarvestBlock((IBlockReader)world, blockPosition, (PlayerEntity)turtlePlayer);
        boolean canBreak = state.removedByPlayer(world, blockPosition, (PlayerEntity)turtlePlayer, canHarvest, fluidState);
        if (canBreak) {
            state.func_177230_c().func_176206_d((IWorld)world, blockPosition, state);
        }
        if (canHarvest && canBreak) {
            state.func_177230_c().func_180657_a(world, (PlayerEntity)turtlePlayer, blockPosition, state, tile, turtlePlayer.func_184614_ca());
        }
        TurtleTool.stopConsuming(turtleTile, turtle);
        return TurtleCommandResult.success();
    }

    private static Function<ItemStack, ItemStack> turtleDropConsumer(TileEntity tile, ITurtleAccess turtle) {
        return drop -> tile.func_145837_r() ? drop : InventoryUtil.storeItems(drop, (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
    }

    private static void stopConsuming(TileEntity tile, ITurtleAccess turtle) {
        Direction direction = tile.func_145837_r() ? null : turtle.getDirection().func_176734_d();
        List<ItemStack> extra = DropConsumer.clear();
        for (ItemStack remainder : extra) {
            WorldUtil.dropItemStack(remainder, turtle.getWorld(), turtle.getPosition(), direction);
        }
    }
}

