/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dan200.computercraft.shared.util.BasicRecipeSerializer;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;

public final class ImpostorShapelessRecipe
extends ShapelessRecipe {
    private final String group;
    public static final IRecipeSerializer<ImpostorShapelessRecipe> SERIALIZER = new BasicRecipeSerializer<ImpostorShapelessRecipe>(){

        public ImpostorShapelessRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = this.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new ImpostorShapelessRecipe(id, s, itemstack, ingredients);
        }

        private NonNullList<Ingredient> readIngredients(JsonArray arrays) {
            NonNullList items = NonNullList.func_191196_a();
            for (int i = 0; i < arrays.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)arrays.get(i));
                if (ingredient.func_203189_d()) continue;
                items.add((Object)ingredient);
            }
            return items;
        }

        public ImpostorShapelessRecipe fromNetwork(@Nonnull ResourceLocation id, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList items = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < items.size(); ++j) {
                items.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            return new ImpostorShapelessRecipe(id, s, result, items);
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull ImpostorShapelessRecipe recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
        }
    };

    private ImpostorShapelessRecipe(@Nonnull ResourceLocation id, @Nonnull String group, @Nonnull ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id, group, result, ingredients);
        this.group = group;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    public boolean func_77569_a(@Nonnull CraftingInventory inv, @Nonnull World world) {
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull CraftingInventory inventory) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

