/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.YieldThreader;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.debug.DebugHandler;
import org.squiddev.cobalt.lib.platform.FileResourceManipulator;
import org.squiddev.cobalt.lib.platform.ResourceManipulator;

public final class LuaState {
    public InputStream stdin;
    public PrintStream stdout;
    public LuaTable stringMetatable;
    public LuaTable booleanMetatable;
    public LuaTable numberMetatable;
    public LuaTable nilMetatable;
    public LuaTable functionMetatable;
    public LuaTable threadMetatable;
    public final LuaTable loadedPackages = new LuaTable();
    public final ResourceManipulator resourceManipulator;
    public final LoadState.LuaCompiler compiler;
    public final DebugHandler debug;
    public final TimeZone timezone;
    public Random random;
    LuaThread currentThread;
    private LuaThread mainThread;
    final YieldThreader threader;
    boolean abandoned;

    public LuaState() {
        this(new Builder());
    }

    private LuaState(Builder builder) {
        this.stdin = builder.stdin;
        this.stdout = builder.stdout;
        this.stringMetatable = builder.stringMetatable;
        this.booleanMetatable = builder.booleanMetatable;
        this.numberMetatable = builder.numberMetatable;
        this.nilMetatable = builder.nilMetatable;
        this.functionMetatable = builder.functionMetatable;
        this.threadMetatable = builder.threadMetatable;
        this.resourceManipulator = builder.resourceManipulator;
        this.compiler = builder.compiler;
        this.random = builder.random;
        this.debug = builder.debug;
        this.timezone = builder.timezone;
        this.threader = new YieldThreader(builder.coroutineExecutor);
    }

    public void abandon() {
        this.abandoned = true;
    }

    public LuaThread getMainThread() {
        return this.mainThread;
    }

    public LuaThread getCurrentThread() {
        return this.currentThread;
    }

    public void setupThread(LuaTable environment) {
        LuaThread thread;
        if (this.mainThread != null && this.mainThread.isAlive()) {
            throw new IllegalStateException("State already has main thread");
        }
        this.mainThread = thread = new LuaThread(this, environment);
        this.currentThread = thread;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final AtomicInteger coroutineCount = new AtomicInteger();
        private static final Executor defaultCoroutineExecutor = Executors.newCachedThreadPool(command -> {
            Thread thread = new Thread(command, "Coroutine-" + coroutineCount.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        private InputStream stdin = System.in;
        private PrintStream stdout = System.out;
        private LuaTable stringMetatable;
        private LuaTable booleanMetatable;
        private LuaTable numberMetatable;
        private LuaTable nilMetatable;
        private LuaTable functionMetatable;
        private LuaTable threadMetatable;
        private ResourceManipulator resourceManipulator = new FileResourceManipulator();
        private LoadState.LuaCompiler compiler = LuaC.INSTANCE;
        private Random random = new Random();
        private DebugHandler debug = DebugHandler.INSTANCE;
        private TimeZone timezone = TimeZone.getDefault();
        private Executor coroutineExecutor = defaultCoroutineExecutor;

        public LuaState build() {
            return new LuaState(this);
        }

        public Builder stdin(InputStream stdin) {
            if (stdin == null) {
                throw new NullPointerException("stdin cannot be null");
            }
            this.stdin = stdin;
            return this;
        }

        public Builder stdout(PrintStream stdout) {
            if (stdout == null) {
                throw new NullPointerException("stdout cannot be null");
            }
            this.stdout = stdout;
            return this;
        }

        public Builder stringMetatable(LuaTable metatable) {
            this.stringMetatable = metatable;
            return this;
        }

        public Builder booleanMetatable(LuaTable metatable) {
            this.booleanMetatable = metatable;
            return this;
        }

        public Builder numberMetatable(LuaTable metatable) {
            this.numberMetatable = metatable;
            return this;
        }

        public Builder nilMetatable(LuaTable metatable) {
            this.nilMetatable = metatable;
            return this;
        }

        public Builder functionMetatable(LuaTable metatable) {
            this.functionMetatable = metatable;
            return this;
        }

        public Builder threadMetatable(LuaTable metatable) {
            this.threadMetatable = metatable;
            return this;
        }

        public Builder resourceManipulator(ResourceManipulator resourceManipulator) {
            if (this.resourceManipulator == null) {
                throw new NullPointerException("resourceManipulator cannot be null");
            }
            this.resourceManipulator = resourceManipulator;
            return this;
        }

        public Builder compiler(LoadState.LuaCompiler compiler) {
            if (compiler == null) {
                throw new NullPointerException("compiler cannot be null");
            }
            this.compiler = compiler;
            return this;
        }

        public Builder random(Random random) {
            if (random == null) {
                throw new NullPointerException("random cannot be null");
            }
            this.random = random;
            return this;
        }

        public Builder debug(DebugHandler debug) {
            if (debug == null) {
                throw new NullPointerException("debug cannot be null");
            }
            this.debug = debug;
            return this;
        }

        public Builder timezone(TimeZone zone) {
            if (zone == null) {
                throw new NullPointerException("zone cannot be null");
            }
            this.timezone = zone;
            return this;
        }

        public Builder coroutineExecutor(Executor coroutineExecutor) {
            if (coroutineExecutor == null) {
                throw new NullPointerException("coroutineExecutor cannot be null");
            }
            this.coroutineExecutor = coroutineExecutor;
            return this;
        }
    }
}

