/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.IOException;
import java.io.InputStream;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.FuncState;
import org.squiddev.cobalt.compiler.InstructionPtr;
import org.squiddev.cobalt.compiler.LexState;
import org.squiddev.cobalt.compiler.LoadState;
import org.squiddev.cobalt.function.LocalVariable;
import org.squiddev.cobalt.function.LuaFunction;
import org.squiddev.cobalt.function.LuaInterpretedFunction;

public class LuaC
implements LoadState.LuaCompiler {
    public static final LuaC INSTANCE = new LuaC();
    public static final int MAXSTACK = 250;
    public static final int LUAI_MAXUPVALUES = 60;
    public static final int LUAI_MAXVARS = 200;

    protected static void _assert(boolean b) throws CompileException {
        if (!b) {
            throw new CompileException("compiler assert failed");
        }
    }

    public static void SET_OPCODE(InstructionPtr i, int o) {
        i.set(i.get() & 0xFFFFFFC0 | o << 0 & 0x3F);
    }

    public static void SETARG_A(InstructionPtr i, int u) {
        i.set(i.get() & 0xFFFFC03F | u << 6 & 0x3FC0);
    }

    public static void SETARG_B(InstructionPtr i, int u) {
        i.set(i.get() & 0x7FFFFF | u << 23 & 0xFF800000);
    }

    public static void SETARG_C(InstructionPtr i, int u) {
        i.set(i.get() & 0xFF803FFF | u << 14 & 0x7FC000);
    }

    public static void SETARG_Bx(InstructionPtr i, int u) {
        i.set(i.get() & 0x3FFF | u << 14 & 0xFFFFC000);
    }

    public static void SETARG_sBx(InstructionPtr i, int u) {
        LuaC.SETARG_Bx(i, u + 131071);
    }

    public static int CREATE_ABC(int o, int a, int b, int c) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | b << 23 & 0xFF800000 | c << 14 & 0x7FC000;
    }

    public static int CREATE_ABx(int o, int a, int bc) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | bc << 14 & 0xFFFFC000;
    }

    public static LuaValue[] realloc(LuaValue[] v, int n) {
        LuaValue[] a = new LuaValue[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static Prototype[] realloc(Prototype[] v, int n) {
        Prototype[] a = new Prototype[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static LuaString[] realloc(LuaString[] v, int n) {
        LuaString[] a = new LuaString[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static LocalVariable[] realloc(LocalVariable[] v, int n) {
        LocalVariable[] a = new LocalVariable[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static int[] realloc(int[] v, int n) {
        int[] a = new int[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static byte[] realloc(byte[] v, int n) {
        byte[] a = new byte[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    private LuaC() {
    }

    @Override
    public LuaFunction load(InputStream stream, LuaString name, LuaString mode, LuaTable env) throws IOException, CompileException {
        Prototype p = LuaC.compile(stream, name, mode);
        LuaInterpretedFunction closure = new LuaInterpretedFunction(p, env);
        closure.nilUpvalues();
        return closure;
    }

    public static Prototype compile(InputStream stream, String name) throws IOException, CompileException {
        return LuaC.compile(stream, ValueFactory.valueOf(name));
    }

    public static Prototype compile(InputStream stream, LuaString name) throws IOException, CompileException {
        return LuaC.compile(stream, name, null);
    }

    public static Prototype compile(InputStream stream, LuaString name, LuaString mode) throws IOException, CompileException {
        int firstByte = stream.read();
        if (firstByte == 27) {
            LoadState.checkMode(mode, "binary");
            return LoadState.loadBinaryChunk(firstByte, stream, name);
        }
        LoadState.checkMode(mode, "text");
        return LuaC.luaY_parser(firstByte, stream, name);
    }

    private static Prototype luaY_parser(int firstByte, InputStream z, LuaString name) throws CompileException {
        LexState lexstate = new LexState(z);
        FuncState funcstate = new FuncState();
        lexstate.setinput(firstByte, z, name);
        lexstate.open_func(funcstate);
        funcstate.f.is_vararg = 2;
        funcstate.f.source = name;
        lexstate.nextToken();
        lexstate.chunk();
        lexstate.check(284);
        lexstate.close_func();
        LuaC._assert(funcstate.prev == null);
        LuaC._assert(funcstate.f.nups == 0);
        LuaC._assert(lexstate.fs == null);
        return funcstate.f;
    }

    public LuaFunction load(Prototype p, LuaTable env) {
        return new LuaInterpretedFunction(p, env);
    }
}

