/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.jse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.lib.IoLib;

public class JseIoLib
extends IoLib {
    @Override
    protected IoLib.File wrapStandardStream(InputStream stream) throws IOException {
        return new FileImpl(stream, true);
    }

    @Override
    protected IoLib.File wrapStandardStream(OutputStream stream) throws IOException {
        return new FileImpl(stream, true);
    }

    @Override
    protected IoLib.File openFile(String filename, boolean readMode, boolean appendMode, boolean updateMode, boolean binaryMode) throws IOException {
        RandomAccessFile f = new RandomAccessFile(filename, readMode ? "r" : "rw");
        if (appendMode) {
            f.seek(f.length());
        } else if (!readMode) {
            f.setLength(0L);
        }
        return new FileImpl(f);
    }

    @Override
    protected IoLib.File openProgram(String prog, String mode) throws IOException {
        Process p = Runtime.getRuntime().exec(prog);
        return "w".equals(mode) ? new FileImpl(p.getOutputStream(), false) : new FileImpl(p.getInputStream(), false);
    }

    @Override
    protected IoLib.File tmpFile() throws IOException {
        File f = File.createTempFile(".luaj", "bin");
        f.deleteOnExit();
        return new FileImpl(new RandomAccessFile(f, "rw"));
    }

    private final class FileImpl
    extends IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed = false;
        private boolean nobuffer = false;
        private final boolean isStandard;

        private FileImpl(RandomAccessFile file, InputStream is, OutputStream os, boolean isStandard) {
            this.file = file;
            this.is = is != null ? (is.markSupported() ? is : new BufferedInputStream(is)) : null;
            this.os = os;
            this.isStandard = isStandard;
        }

        private FileImpl(RandomAccessFile f) {
            this(f, null, null, false);
        }

        private FileImpl(InputStream i, boolean isStandard) {
            this(null, i, null, isStandard);
        }

        private FileImpl(OutputStream o, boolean isStandard) {
            this(null, null, o, isStandard);
        }

        @Override
        public String toString() {
            return "file (" + (this.isclosed() ? "closed" : Integer.valueOf(this.hashCode())) + ")";
        }

        @Override
        public boolean isstdfile() {
            return this.isStandard;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        @Override
        public void write(LuaString s) throws IOException {
            if (this.os != null) {
                this.os.write(s.bytes, s.offset, s.length);
            } else if (this.file != null) {
                this.file.write(s.bytes, s.offset, s.length);
            } else {
                throw new IOException("not implemented");
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        @Override
        public boolean isclosed() {
            return this.closed;
        }

        @Override
        public int seek(String option, int pos) throws IOException {
            if (this.file != null) {
                if ("set".equals(option)) {
                    this.file.seek(pos);
                } else if ("end".equals(option)) {
                    this.file.seek(this.file.length() + (long)pos);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)pos);
                }
                return (int)this.file.getFilePointer();
            }
            throw new IOException("not implemented");
        }

        @Override
        public void setvbuf(String mode, int size) {
            this.nobuffer = "no".equals(mode);
        }

        @Override
        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        @Override
        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int c = this.is.read();
                this.is.reset();
                return c;
            }
            if (this.file != null) {
                long fp = this.file.getFilePointer();
                int c = this.file.read();
                this.file.seek(fp);
                return c;
            }
            throw new IOException("not implemented");
        }

        @Override
        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            throw new IOException("not implemented");
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.file != null) {
                return this.file.read(bytes, offset, length);
            }
            if (this.is != null) {
                return this.is.read(bytes, offset, length);
            }
            throw new IOException("not implemented");
        }
    }
}

