/*
 * Decompiled with CFR 0.152.
 */
package com.linfox.deeperinbedrock;

import com.linfox.deeperinbedrock.StackedDimensionsWardenMod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class StackedDimensionsWardenModElements {
    public final List<ModElement> elements = new ArrayList<ModElement>();
    public final List<Supplier<Block>> blocks = new ArrayList<Supplier<Block>>();
    public final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    public final List<Supplier<EntityType<?>>> entities = new ArrayList();
    public final List<Supplier<Enchantment>> enchantments = new ArrayList<Supplier<Enchantment>>();
    public static Map<ResourceLocation, SoundEvent> sounds = new HashMap<ResourceLocation, SoundEvent>();
    private int messageID = 0;

    public StackedDimensionsWardenModElements() {
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.warden.hurt"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.warden.hurt")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "music.deep_dark"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "music.deep_dark")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.sculk_zombie.idle"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.sculk_zombie.idle")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.sculk_zombie.hurt"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.sculk_zombie.hurt")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "music_disc.warden_apparition"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "music_disc.warden_apparition")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "block.sculk_sensor"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "block.sculk_sensor")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "block.sculk_sensor.stop"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "block.sculk_sensor.stop")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "block.sculk_trap"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "block.sculk_trap")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.warden.heart_beat"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.warden.heart_beat")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.warden.idle"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.warden.idle")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "entity.warden.breath"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "entity.warden.breath")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.ambience"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.ambience")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.mood"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.mood")));
        sounds.put(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.additions"), new SoundEvent(new ResourceLocation("stacked_dimensions_warden", "ambient.deep_dark.additions")));
        try {
            ModFileScanData modFileInfo = ModList.get().getModFileById("stacked_dimensions_warden").getFile().getScanResult();
            Set annotations = modFileInfo.getAnnotations();
            for (ModFileScanData.AnnotationData annotationData : annotations) {
                Class<?> clazz;
                if (!annotationData.getAnnotationType().getClassName().equals(ModElement.Tag.class.getName()) || (clazz = Class.forName(annotationData.getClassType().getClassName())).getSuperclass() != ModElement.class) continue;
                this.elements.add((ModElement)clazz.getConstructor(this.getClass()).newInstance(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.elements);
        this.elements.forEach(ModElement::initElements);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (Map.Entry<ResourceLocation, SoundEvent> sound : sounds.entrySet()) {
            event.getRegistry().register(sound.getValue().setRegistryName(sound.getKey()));
        }
    }

    public <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        StackedDimensionsWardenMod.PACKET_HANDLER.registerMessage(this.messageID, messageType, encoder, decoder, messageConsumer);
        ++this.messageID;
    }

    public List<ModElement> getElements() {
        return this.elements;
    }

    public List<Supplier<Block>> getBlocks() {
        return this.blocks;
    }

    public List<Supplier<Item>> getItems() {
        return this.items;
    }

    public List<Supplier<EntityType<?>>> getEntities() {
        return this.entities;
    }

    public List<Supplier<Enchantment>> getEnchantments() {
        return this.enchantments;
    }

    public static class ModElement
    implements Comparable<ModElement> {
        protected final StackedDimensionsWardenModElements elements;
        protected final int sortid;

        public ModElement(StackedDimensionsWardenModElements elements, int sortid) {
            this.elements = elements;
            this.sortid = sortid;
        }

        public void initElements() {
        }

        public void init(FMLCommonSetupEvent event) {
        }

        public void serverLoad(FMLServerStartingEvent event) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public void clientLoad(FMLClientSetupEvent event) {
        }

        @Override
        public int compareTo(ModElement other) {
            return this.sortid - other.sortid;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Tag {
        }
    }
}

