/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds;

import de.ellpeck.craftabledeeds.CraftableDeeds;
import de.ellpeck.craftabledeeds.PacketHandler;
import de.ellpeck.craftabledeeds.blocks.DeedPedestalTileEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;

public class DeedStorage
extends WorldSavedData {
    private static final String NAME = "craftabledeeds:deed_storage";
    private static DeedStorage clientStorage;
    public Map<BlockPos, DeedPedestalTileEntity> pedestals = new HashMap<BlockPos, DeedPedestalTileEntity>();
    private final World world;
    private final Map<Integer, Claim> claims = new HashMap<Integer, Claim>();

    public DeedStorage(World world) {
        super(NAME);
        this.world = world;
    }

    public void addClaim(int id, PlayerEntity owner) {
        this.claims.put(id, new Claim(this.world, id, owner.func_110124_au()));
        this.markDirtyAndSend();
    }

    public void removeClaim(int id) {
        if (this.claims.remove(id) != null) {
            this.markDirtyAndSend();
        }
    }

    public Claim getClaim(double x, double y, double z) {
        for (Claim claim : this.claims.values()) {
            if (!claim.getArea().func_197744_e(x, y, z)) continue;
            return claim;
        }
        return null;
    }

    public Claim getClaim(int id) {
        return this.claims.get(id);
    }

    public void update() {
        int interval = 40;
        if (this.world.field_72995_K || this.world.func_82737_E() % (long)interval != 0L) {
            return;
        }
        block0: for (Claim claim : this.claims.values()) {
            if (claim.cooldown > 0) {
                claim.cooldown -= interval;
                if (claim.cooldown <= 0) {
                    this.removeClaim(claim.mapId);
                    continue;
                }
            }
            if (claim.pedestal != null) {
                ItemStack stack;
                DeedPedestalTileEntity existing = this.pedestals.get(claim.pedestal);
                if (existing != null && (stack = existing.items.getStackInSlot(0)).func_77973_b() == CraftableDeeds.FILLED_DEED.get() && FilledMapItem.func_195949_f((ItemStack)stack) == claim.mapId) continue;
                claim.pedestal = null;
                this.markDirtyAndSend();
            }
            AxisAlignedBB area = claim.getArea();
            for (DeedPedestalTileEntity tile : this.pedestals.values()) {
                ItemStack stack;
                BlockPos pos = tile.func_174877_v();
                if (!area.func_197744_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) || (stack = tile.items.getStackInSlot(0)).func_77973_b() != CraftableDeeds.FILLED_DEED.get() || FilledMapItem.func_195949_f((ItemStack)stack) != claim.mapId) continue;
                claim.pedestal = pos;
                this.markDirtyAndSend();
                continue block0;
            }
        }
    }

    public void markDirtyAndSend() {
        if (!this.world.field_72995_K) {
            PacketHandler.sendDeedsToEveryone(this.world);
            this.func_76185_a();
        }
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.claims.clear();
        ListNBT claims = nbt.func_150295_c("claims", 10);
        for (int i = 0; i < claims.size(); ++i) {
            Claim claim = new Claim(this.world, claims.func_150305_b(i));
            this.claims.put(claim.mapId, claim);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT claims = new ListNBT();
        for (Claim claim : this.claims.values()) {
            claims.add((Object)claim.serializeNBT());
        }
        compound.func_218657_a("claims", (INBT)claims);
        return compound;
    }

    public static DeedStorage get(World world) {
        if (world.field_72995_K) {
            if (clientStorage == null || DeedStorage.clientStorage.world != world) {
                clientStorage = new DeedStorage(world);
            }
            return clientStorage;
        }
        return (DeedStorage)((ServerWorld)world).func_217481_x().func_215752_a(() -> new DeedStorage(world), NAME);
    }

    public static class PlayerSettings
    implements INBTSerializable<CompoundNBT> {
        public UUID id;
        public String name;
        public boolean isFake;
        public boolean canPlaceBreak;
        public boolean loyalMobsAttack;
        public boolean canOpenContainers;

        public PlayerSettings(PlayerEntity player) {
            this.id = player.func_110124_au();
            this.name = player.func_145748_c_().getString();
            this.isFake = player instanceof FakePlayer;
        }

        public PlayerSettings(CompoundNBT nbt) {
            this.deserializeNBT(nbt);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_186854_a("id", this.id);
            nbt.func_74778_a("name", this.name);
            nbt.func_74757_a("isFake", this.isFake);
            nbt.func_74757_a("canPlaceBreak", this.canPlaceBreak);
            nbt.func_74757_a("loyalMobsAttack", this.loyalMobsAttack);
            nbt.func_74757_a("canOpenContainers", this.canOpenContainers);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.id = nbt.func_186857_a("id");
            this.name = nbt.func_74779_i("name");
            this.isFake = nbt.func_74767_n("isFake");
            this.canPlaceBreak = nbt.func_74767_n("canPlaceBreak");
            this.loyalMobsAttack = nbt.func_74767_n("loyalMobsAttack");
            this.canOpenContainers = nbt.func_74767_n("canOpenContainers");
        }
    }

    public static class Claim
    implements INBTSerializable<CompoundNBT> {
        public final Map<UUID, PlayerSettings> playerSettings = new HashMap<UUID, PlayerSettings>();
        public int mapId;
        public UUID owner;
        public BlockPos pedestal;
        public int cooldown;
        public boolean canDispensersPlace = true;
        public boolean canPistonsPush = true;
        private final World world;
        private int xCenter;
        private int zCenter;
        private int scale;

        public Claim(World world, int mapId, UUID owner) {
            MapData data = world.func_217406_a(FilledMapItem.func_219993_a((int)mapId));
            this.world = world;
            this.mapId = mapId;
            this.owner = owner;
            this.xCenter = data.field_76201_a;
            this.zCenter = data.field_76199_b;
            this.scale = data.field_76197_d;
        }

        public Claim(World world, CompoundNBT nbt) {
            this.world = world;
            this.deserializeNBT(nbt);
        }

        public AxisAlignedBB getArea() {
            int i = 1 << this.scale;
            return new AxisAlignedBB((double)(this.xCenter - 64 * i), 15.0, (double)(this.zCenter - 64 * i), (double)(this.xCenter + 64 * i), (double)this.world.func_217301_I(), (double)(this.zCenter + 64 * i));
        }

        public Object getOwnerName() {
            PlayerEntity owner = this.world.func_217371_b(this.owner);
            return owner != null ? owner.func_145748_c_() : this.owner;
        }

        public boolean isActive() {
            if (this.cooldown > 0) {
                return false;
            }
            return (Boolean)CraftableDeeds.requirePedestals.get() == false || this.pedestal != null;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("id", this.mapId);
            nbt.func_186854_a("owner", this.owner);
            nbt.func_74768_a("xCenter", this.xCenter);
            nbt.func_74768_a("zCenter", this.zCenter);
            nbt.func_74768_a("scale", this.scale);
            nbt.func_74768_a("cooldown", this.cooldown);
            nbt.func_74757_a("canDispensersPlace", this.canDispensersPlace);
            nbt.func_74757_a("canPistonsPush", this.canPistonsPush);
            if (this.pedestal != null) {
                nbt.func_74772_a("pedestal", this.pedestal.func_218275_a());
            }
            ListNBT playerSettings = new ListNBT();
            for (PlayerSettings settings : this.playerSettings.values()) {
                playerSettings.add((Object)settings.serializeNBT());
            }
            nbt.func_218657_a("playerSettings", (INBT)playerSettings);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.mapId = nbt.func_74762_e("id");
            this.owner = nbt.func_186857_a("owner");
            this.xCenter = nbt.func_74762_e("xCenter");
            this.zCenter = nbt.func_74762_e("zCenter");
            this.scale = nbt.func_74762_e("scale");
            this.cooldown = nbt.func_74762_e("cooldown");
            this.canDispensersPlace = nbt.func_74767_n("canDispensersPlace");
            this.canPistonsPush = nbt.func_74767_n("canPistonsPush");
            this.pedestal = nbt.func_74764_b("pedestal") ? BlockPos.func_218283_e((long)nbt.func_74763_f("pedestal")) : null;
            this.playerSettings.clear();
            for (INBT inbt : nbt.func_150295_c("playerSettings", 10)) {
                PlayerSettings settings = new PlayerSettings((CompoundNBT)inbt);
                this.playerSettings.put(settings.id, settings);
            }
        }
    }
}

