/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds;

import com.mojang.brigadier.CommandDispatcher;
import de.ellpeck.craftabledeeds.CraftableDeeds;
import de.ellpeck.craftabledeeds.DeedCommand;
import de.ellpeck.craftabledeeds.DeedStorage;
import de.ellpeck.craftabledeeds.PacketHandler;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class Events {
    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K) {
            if (entity instanceof PlayerEntity) {
                PacketHandler.sendDeeds((PlayerEntity)entity);
            } else if (entity instanceof IronGolemEntity || entity instanceof SnowGolemEntity || entity instanceof WolfEntity || ((List)CraftableDeeds.additionalLoyalMobs.get()).contains(entity.func_200600_R().getRegistryName().toString())) {
                MobEntity mob = (MobEntity)entity;
                mob.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal(mob, PlayerEntity.class, 10, false, false, p -> {
                    if (mob instanceof TameableEntity && !((TameableEntity)mob).func_70909_n()) {
                        return false;
                    }
                    if (Events.isDisallowedHere((Entity)p, p.func_233580_cy_(), s -> !s.loyalMobsAttack)) {
                        if (mob instanceof IronGolemEntity) {
                            ((IronGolemEntity)mob).func_70849_f(false);
                        }
                        return true;
                    }
                    return false;
                }));
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DeedStorage.get(event.world).update();
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (Events.isDisallowedHere((Entity)event.getPlayer(), event.getPos(), s -> s.canPlaceBreak)) {
            if (Events.isExemptConfig((List<? extends String>)((List)CraftableDeeds.breakableBlocks.get()), event.getState().func_177230_c())) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Events.isDisallowedHere(event.getEntity(), event.getPos(), s -> s.canPlaceBreak)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (Events.isDisallowedHere((Entity)event.getPlayer(), event.getPos(), s -> s.canOpenContainers)) {
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state.func_177230_c() == CraftableDeeds.DEED_PEDESTAL_BLOCK.get()) {
                return;
            }
            if (Events.isExemptConfig((List<? extends String>)((List)CraftableDeeds.interactableBlocks.get()), state.func_177230_c())) {
                return;
            }
            if (!((Boolean)CraftableDeeds.allowOpeningBlocks.get()).booleanValue()) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
        if (Events.isDisallowedHere((Entity)event.getPlayer(), event.getPos(), s -> s.canPlaceBreak)) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (Events.isDisallowedHere((Entity)event.getPlayer(), event.getPos(), s -> s.canPlaceBreak)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (Events.isDisallowedHere((Entity)event.getPlayer(), event.getPos(), null)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (target instanceof HangingEntity && Events.isDisallowedHere((Entity)event.getPlayer(), target.func_233580_cy_(), null)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if ((entity instanceof EndermanEntity || entity instanceof ZombieEntity || entity instanceof CreeperEntity && !((Boolean)CraftableDeeds.allowCreeperExplosions.get()).booleanValue()) && Events.isDisallowedHere(entity, entity.func_233580_cy_(), null)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start event) {
        Explosion explosion = event.getExplosion();
        Entity exploder = explosion.getExploder();
        if (exploder != null && Events.isDisallowedHere(exploder, new BlockPos(explosion.getPosition()), null)) {
            if (exploder instanceof CreeperEntity) {
                return;
            }
            if (exploder instanceof TNTEntity && ((Boolean)CraftableDeeds.allowTntExplosions.get()).booleanValue()) {
                return;
            }
            if ((exploder instanceof WitherEntity || exploder instanceof WitherSkullEntity) && ((Boolean)CraftableDeeds.allowWitherExplosions.get()).booleanValue()) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPiston(PistonEvent.Pre event) {
        DeedStorage storage;
        DeedStorage.Claim claim;
        if (event.getWorld() instanceof World && (claim = (storage = DeedStorage.get((World)event.getWorld())).getClaim(event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) != null && claim.isActive() && !claim.canPistonsPush) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(RegisterCommandsEvent event) {
        DeedCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private static boolean isDisallowedHere(Entity entity, BlockPos pos, Function<DeedStorage.PlayerSettings, Boolean> relevantSetting) {
        if (entity.func_211513_k(((Integer)CraftableDeeds.deedBypassPermissionLevel.get()).intValue())) {
            return false;
        }
        DeedStorage storage = DeedStorage.get(entity.field_70170_p);
        DeedStorage.Claim claim = storage.getClaim(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (claim == null || !claim.isActive()) {
            return false;
        }
        if (claim.owner.equals(entity.func_110124_au())) {
            return false;
        }
        if (relevantSetting != null && entity instanceof PlayerEntity) {
            DeedStorage.PlayerSettings settings;
            if (!claim.playerSettings.containsKey(entity.func_110124_au())) {
                claim.playerSettings.put(entity.func_110124_au(), new DeedStorage.PlayerSettings((PlayerEntity)entity));
                storage.markDirtyAndSend();
            }
            if ((settings = claim.playerSettings.get(entity.func_110124_au())) != null && relevantSetting.apply(settings).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private static boolean isExemptConfig(List<? extends String> config, Block block) {
        return Events.isExemptConfig(config, block.getRegistryName().toString());
    }

    private static boolean isExemptConfig(List<? extends String> config, String search) {
        return config.stream().anyMatch(search::matches);
    }
}

