/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds;

import de.ellpeck.craftabledeeds.DeedStorage;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public final class PacketHandler {
    private static SimpleChannel network;

    public static void init(FMLCommonSetupEvent event) {
        String version = "1";
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("craftabledeeds", "network"), () -> version, version::equals, version::equals);
        network.registerMessage(0, PacketDeeds.class, PacketDeeds::toBytes, PacketDeeds::fromBytes, PacketDeeds::onMessage);
        network.registerMessage(1, PacketPlayerSettings.class, PacketPlayerSettings::toBytes, PacketPlayerSettings::fromBytes, PacketPlayerSettings::onMessage);
        network.registerMessage(2, PacketGeneralSettings.class, PacketGeneralSettings::toBytes, PacketGeneralSettings::fromBytes, PacketGeneralSettings::onMessage);
    }

    public static void sendDeeds(PlayerEntity player) {
        PacketDeeds packet = new PacketDeeds(DeedStorage.get(player.field_70170_p).func_189551_b(new CompoundNBT()));
        network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)packet);
    }

    public static void sendDeedsToEveryone(World world) {
        PacketDeeds packet = new PacketDeeds(DeedStorage.get(world).func_189551_b(new CompoundNBT()));
        network.send(PacketDistributor.DIMENSION.with(() -> ((World)world).func_234923_W_()), (Object)packet);
    }

    public static void sendPlayerSettings(DeedStorage.PlayerSettings settings, DeedStorage.Claim claim) {
        network.sendToServer((Object)new PacketPlayerSettings(settings, claim.mapId));
    }

    public static void sendGeneralSettings(DeedStorage.Claim claim) {
        network.sendToServer((Object)new PacketGeneralSettings(claim.canDispensersPlace, claim.canPistonsPush, claim.mapId));
    }

    public static void sendTileEntityToClients(TileEntity tile) {
        ServerWorld world = (ServerWorld)tile.func_145831_w();
        Stream entities = world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(tile.func_174877_v()), false);
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket(tile.func_174877_v(), -1, tile.func_189515_b(new CompoundNBT()));
        entities.forEach(e -> e.field_71135_a.func_147359_a((IPacket)packet));
    }

    private static class PacketGeneralSettings {
        private final int claimId;
        private final boolean canDispensersPlace;
        private final boolean canPistonsPush;

        public PacketGeneralSettings(boolean canDispensersPlace, boolean canPistonsPush, int claimId) {
            this.canDispensersPlace = canDispensersPlace;
            this.canPistonsPush = canPistonsPush;
            this.claimId = claimId;
        }

        public static PacketGeneralSettings fromBytes(PacketBuffer buf) {
            return new PacketGeneralSettings(buf.readBoolean(), buf.readBoolean(), buf.func_150792_a());
        }

        public static void toBytes(PacketGeneralSettings packet, PacketBuffer buf) {
            buf.writeBoolean(packet.canDispensersPlace);
            buf.writeBoolean(packet.canPistonsPush);
            buf.func_150787_b(packet.claimId);
        }

        public static void onMessage(PacketGeneralSettings packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                DeedStorage storage = DeedStorage.get(sender.field_70170_p);
                DeedStorage.Claim claim = storage.getClaim(packet.claimId);
                if (claim != null && claim.owner.equals(sender.func_110124_au())) {
                    claim.canDispensersPlace = packet.canDispensersPlace;
                    claim.canPistonsPush = packet.canPistonsPush;
                    storage.markDirtyAndSend();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class PacketPlayerSettings {
        private final DeedStorage.PlayerSettings settings;
        private final int claimId;

        public PacketPlayerSettings(DeedStorage.PlayerSettings settings, int claimId) {
            this.settings = settings;
            this.claimId = claimId;
        }

        public static PacketPlayerSettings fromBytes(PacketBuffer buf) {
            return new PacketPlayerSettings(new DeedStorage.PlayerSettings(buf.func_150793_b()), buf.func_150792_a());
        }

        public static void toBytes(PacketPlayerSettings packet, PacketBuffer buf) {
            buf.func_150786_a(packet.settings.serializeNBT());
            buf.func_150787_b(packet.claimId);
        }

        public static void onMessage(PacketPlayerSettings packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                DeedStorage storage = DeedStorage.get(sender.field_70170_p);
                DeedStorage.Claim claim = storage.getClaim(packet.claimId);
                if (claim != null && claim.owner.equals(sender.func_110124_au())) {
                    claim.playerSettings.put(packet.settings.id, packet.settings);
                    storage.markDirtyAndSend();
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static class PacketDeeds {
        private final CompoundNBT data;

        public PacketDeeds(CompoundNBT data) {
            this.data = data;
        }

        public static PacketDeeds fromBytes(PacketBuffer buf) {
            return new PacketDeeds(buf.func_150793_b());
        }

        public static void toBytes(PacketDeeds packet, PacketBuffer buf) {
            buf.func_150786_a(packet.data);
        }

        public static void onMessage(final PacketDeeds packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    if (mc.field_71441_e != null) {
                        DeedStorage.get((World)mc.field_71441_e).func_76184_a(packet.data);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

