/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds.blocks;

import de.ellpeck.craftabledeeds.CraftableDeeds;
import de.ellpeck.craftabledeeds.DeedStorage;
import de.ellpeck.craftabledeeds.PacketHandler;
import de.ellpeck.craftabledeeds.blocks.DeedPedestalTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public class DeedPedestalBlock
extends ContainerBlock {
    private static final VoxelShape SHAPE = DeedPedestalBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public DeedPedestalBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196696_di).func_200948_a(5.0f, 1200.0f));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof DeedPedestalTileEntity)) {
            return ActionResultType.FAIL;
        }
        DeedPedestalTileEntity pedestal = (DeedPedestalTileEntity)tile;
        ItemStackHandler items = pedestal.items;
        ItemStack contained = items.getStackInSlot(0);
        ItemStack hand = player.func_184586_b(handIn);
        if (contained.func_190926_b()) {
            if (hand.func_77973_b() == CraftableDeeds.FILLED_DEED.get()) {
                if (!worldIn.field_72995_K) {
                    items.setStackInSlot(0, hand);
                    player.func_184611_a(handIn, ItemStack.field_190927_a);
                    PacketHandler.sendTileEntityToClients(pedestal);
                }
                return ActionResultType.SUCCESS;
            }
        } else {
            DeedStorage.Claim claim = pedestal.getClaim();
            if (claim.owner.equals(player.func_110124_au()) && !player.func_225608_bj_()) {
                if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)pedestal, (BlockPos)pos);
                }
                return ActionResultType.SUCCESS;
            }
            if (!worldIn.field_72995_K) {
                items.setStackInSlot(0, ItemStack.field_190927_a);
                PacketHandler.sendTileEntityToClients(pedestal);
                if (claim.owner.equals(player.func_110124_au())) {
                    if (!player.func_191521_c(contained)) {
                        worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.5f), contained));
                    }
                } else {
                    worldIn.func_217385_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 2.0f, Explosion.Mode.NONE);
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack((IItemProvider)Items.field_151156_bN)));
                    claim.cooldown = (Integer)CraftableDeeds.claimCooldown.get() * 20 * 60 * 60;
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) instanceof DeedPedestalTileEntity) {
            ItemStackHandler handler = ((DeedPedestalTileEntity)tile).items;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new DeedPedestalTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

