/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds.blocks;

import de.ellpeck.craftabledeeds.CraftableDeeds;
import de.ellpeck.craftabledeeds.DeedStorage;
import de.ellpeck.craftabledeeds.items.FilledDeedItem;
import de.ellpeck.craftabledeeds.ui.DeedPedestalContainer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemStackHandler;

public class DeedPedestalTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public final ItemStackHandler items = new ItemStackHandler(1);

    public DeedPedestalTileEntity() {
        super((TileEntityType)CraftableDeeds.DEED_PEDESTAL_TILE.get());
    }

    public int getMapId() {
        ItemStack stack = this.items.getStackInSlot(0);
        if (stack.func_77973_b() == CraftableDeeds.FILLED_DEED.get()) {
            return FilledMapItem.func_195949_f((ItemStack)stack);
        }
        return -1;
    }

    public MapData getMapData() {
        int id = this.getMapId();
        if (id >= 0) {
            return this.field_145850_b.func_217406_a(FilledDeedItem.func_219993_a((int)id));
        }
        return null;
    }

    public DeedStorage.Claim getClaim() {
        int mapId = this.getMapId();
        if (mapId >= 0) {
            return DeedStorage.get(this.field_145850_b).getClaim(mapId);
        }
        return null;
    }

    public void func_73660_a() {
        MapData data;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L && (data = this.getMapData()) != null) {
            ItemStack stack = this.items.getStackInSlot(0);
            ((ServerChunkProvider)this.field_145850_b.func_72863_F()).field_217237_a.func_219097_a(new ChunkPos(this.field_174879_c), false).forEach(p -> {
                IPacket ipacket = data.func_82568_a((PlayerEntity)p).func_176101_a(stack);
                if (ipacket != null) {
                    p.field_71135_a.func_147359_a(ipacket);
                }
            });
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        DeedStorage.get((World)this.field_145850_b).pedestals.put(this.field_174879_c, this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        DeedStorage.get((World)this.field_145850_b).pedestals.remove(this.field_174879_c);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.items.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.items.deserializeNBT(nbt.func_74775_l("items"));
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.craftabledeeds.deed_pedestal");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new DeedPedestalContainer(id, player, this.field_174879_c);
    }
}

