/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds.items;

import de.ellpeck.craftabledeeds.CraftableDeeds;
import de.ellpeck.craftabledeeds.DeedStorage;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class EmptyDeedItem
extends Item {
    public EmptyDeedItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_234689_a_());
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        List dims = (List)CraftableDeeds.allowedDimensions.get();
        if (!dims.contains("*") && !dims.contains(worldIn.func_234923_W_().func_240901_a_().toString())) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("info.craftabledeeds.disallowed_dimension"), true);
            return ActionResult.func_226251_d_((Object)held);
        }
        DeedStorage storage = DeedStorage.get(worldIn);
        DeedStorage.Claim existing = storage.getClaim(playerIn.func_226277_ct_(), 64.0, playerIn.func_226281_cx_());
        if (existing != null) {
            if (existing.cooldown <= 0 || !existing.owner.equals(playerIn.func_110124_au())) {
                if (!worldIn.field_72995_K) {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("info.craftabledeeds.already_claimed", new Object[]{existing.getOwnerName()}), true);
                }
                return ActionResult.func_226251_d_((Object)held);
            }
            if (!worldIn.field_72995_K) {
                storage.removeClaim(existing.mapId);
            }
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            held.func_190918_g(1);
        }
        ItemStack filled = new ItemStack((IItemProvider)CraftableDeeds.FILLED_DEED.get());
        EmptyDeedItem.createMapData(filled, playerIn, MathHelper.func_76128_c((double)playerIn.func_226277_ct_()), MathHelper.func_76128_c((double)playerIn.func_226281_cx_()), 0, true, false);
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        playerIn.func_184185_a(SoundEvents.field_219718_mk, 1.0f, 1.0f);
        playerIn.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
        if (held.func_190926_b()) {
            return ActionResult.func_233538_a_((Object)filled, (boolean)worldIn.func_201670_d());
        }
        if (!playerIn.field_71071_by.func_70441_a(filled.func_77946_l())) {
            playerIn.func_71019_a(filled, false);
        }
        return ActionResult.func_233538_a_((Object)held, (boolean)worldIn.func_201670_d());
    }

    public static MapData createMapData(ItemStack stack, PlayerEntity player, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking) {
        int id = player.field_70170_p.func_217395_y();
        MapData ret = new MapData(FilledMapItem.func_219993_a((int)id));
        ret.func_237241_a_(x, z, scale, trackingPosition, unlimitedTracking, player.field_70170_p.func_234923_W_());
        player.field_70170_p.func_217399_a(ret);
        if (!player.field_70170_p.field_72995_K) {
            DeedStorage.get(player.field_70170_p).addClaim(id, player);
        }
        if (!stack.func_190926_b()) {
            stack.func_196082_o().func_74768_a("map", id);
        }
        return ret;
    }
}

