/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.craftabledeeds.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.craftabledeeds.DeedStorage;
import de.ellpeck.craftabledeeds.PacketHandler;
import de.ellpeck.craftabledeeds.ui.DeedPedestalContainer;
import de.ellpeck.craftabledeeds.ui.ProperToggleWidget;
import de.ellpeck.craftabledeeds.ui.TextWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DeedPedestalScreen
extends ContainerScreen<DeedPedestalContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("craftabledeeds", "textures/ui/deed_pedestal.png");
    private static final int MAX_WIDGET_AMT_Y = 5;
    private Tab currentTab;
    private int scrollOffset;
    private int widgetAmountY;
    private boolean isScrolling;

    public DeedPedestalScreen(DeedPedestalContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 240;
        this.field_147000_g = 144;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.setTab(Tab.PLAYERS);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        for (Widget widget : this.field_230710_m_) {
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrixStack, mouseX, mouseY);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.widgetAmountY > 5) {
            float percentage = (float)this.scrollOffset / (float)(this.widgetAmountY - 5);
            this.func_238474_b_(matrixStack, this.field_147003_i + 223, this.field_147009_r + 19 + (int)(percentage * 105.0f), 232, 241, 12, 15);
        } else {
            this.func_238474_b_(matrixStack, this.field_147003_i + 223, this.field_147009_r + 19, 244, 241, 12, 15);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x404040);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)(this.field_147003_i + 223) && mouseY >= (double)(this.field_147009_r + 19) && mouseX < (double)(this.field_147003_i + 223 + 12) && mouseY < (double)(this.field_147009_r + 19 + 120)) {
            this.isScrolling = true;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int i, double j, double k) {
        if (this.isScrolling && this.widgetAmountY > 5) {
            float percentage = MathHelper.func_76131_a((float)(((float)mouseY - (float)(this.field_147009_r + 19)) / 105.0f), (float)0.0f, (float)1.0f);
            int offset = (int)(percentage * (float)(this.widgetAmountY - 5));
            if (offset != this.scrollOffset) {
                this.scrollOffset = offset;
                this.setTab(this.currentTab);
            }
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, i, j, k);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        int offset;
        if (this.widgetAmountY > 5 && (offset = MathHelper.func_76125_a((int)(this.scrollOffset - (int)Math.signum(scroll)), (int)0, (int)(this.widgetAmountY - 5))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.setTab(this.currentTab);
        }
        return true;
    }

    private void setTab(Tab newTab) {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        int yOffset = 16;
        int uOffset = 0;
        for (Tab tab : Tab.values()) {
            this.func_230480_a_((Widget)new TabWidget(this.field_147003_i - 28, this.field_147009_r + yOffset, 32, 28, 1 + uOffset, 167, tab));
            yOffset += 29;
            uOffset += 33;
        }
        this.currentTab = newTab;
        List<Widget> content = newTab.init.apply(this);
        this.widgetAmountY = content.size() / newTab.widgetAmountX;
        for (int y = 0; y < 5; ++y) {
            if (y >= this.widgetAmountY) {
                return;
            }
            int xOffset = 4;
            for (int x = 0; x < newTab.widgetAmountX; ++x) {
                Widget widget = this.func_230480_a_(content.get((this.scrollOffset + y) * newTab.widgetAmountX + x));
                widget.field_230690_l_ = this.field_147003_i + xOffset;
                widget.field_230691_m_ = this.field_147009_r + 18 + 25 * y;
                xOffset += widget.func_230998_h_() + 1;
            }
        }
    }

    private static enum Tab {
        PLAYERS(screen -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            ArrayList<ProperToggleWidget> allPlaceBreak = new ArrayList<ProperToggleWidget>();
            ArrayList<ProperToggleWidget> allLoyalAttack = new ArrayList<ProperToggleWidget>();
            ArrayList<ProperToggleWidget> allContainers = new ArrayList<ProperToggleWidget>();
            DeedStorage.Claim claim = ((DeedPedestalContainer)((DeedPedestalScreen)screen).field_147002_h).tile.getClaim();
            claim.playerSettings.values().stream().filter(s -> !s.isFake).forEach(s -> ret.addAll(Tab.createPlayerRow(screen, s, allPlaceBreak, allLoyalAttack, allContainers)));
            for (PlayerEntity player : ((DeedPedestalContainer)((DeedPedestalScreen)screen).field_147002_h).tile.func_145831_w().func_217369_A()) {
                if (claim.playerSettings.containsKey(player.func_110124_au()) || claim.owner.equals(player.func_110124_au())) continue;
                ret.addAll(Tab.createPlayerRow(screen, new DeedStorage.PlayerSettings(player), allPlaceBreak, allLoyalAttack, allContainers));
            }
            if (ret.size() > 0) {
                ret.add(0, (Object)new TextWidget(0, 0, 148, 22, (ITextComponent)new TranslationTextComponent("info.craftabledeeds.set_all")));
                ret.add(1, (Object)new ProperToggleWidget(0, 0, 22, 22, 100, 167, 22, 0, TEXTURE, "info.craftabledeeds.can_place_break", allPlaceBreak.stream().allMatch(ToggleWidget::func_191754_c), v -> allPlaceBreak.forEach(w -> w.func_191753_b((boolean)v))));
                ret.add(2, (Object)new ProperToggleWidget(0, 0, 22, 22, 100, 190, 22, 0, TEXTURE, "info.craftabledeeds.loyal_mobs_attack", allLoyalAttack.stream().allMatch(ToggleWidget::func_191754_c), v -> allLoyalAttack.forEach(w -> w.func_191753_b((boolean)v))));
                ret.add(3, (Object)new ProperToggleWidget(0, 0, 22, 22, 100, 213, 22, 0, TEXTURE, "info.craftabledeeds.can_open_containers", allContainers.stream().allMatch(ToggleWidget::func_191754_c), v -> allContainers.forEach(w -> w.func_191753_b((boolean)v))));
            }
            return ret;
        }, 4),
        BLOCKS(screen -> {
            ArrayList<Object> ret = new ArrayList<Object>();
            ArrayList<ProperToggleWidget> allPlaceBreak = new ArrayList<ProperToggleWidget>();
            DeedStorage.Claim claim = ((DeedPedestalContainer)((DeedPedestalScreen)screen).field_147002_h).tile.getClaim();
            ret.add((Object)new TextWidget(0, 0, 148, 22, (ITextComponent)Blocks.field_150367_z.func_235333_g_()));
            ProperToggleWidget w = new ProperToggleWidget(0, 0, 22, 22, 100, 167, 22, 0, TEXTURE, "info.craftabledeeds.can_edit_world", claim.canDispensersPlace, v -> {
                claim.canDispensersPlace = v;
                PacketHandler.sendGeneralSettings(claim);
            });
            ret.add((Object)w);
            allPlaceBreak.add(w);
            ret.add((Object)new TextWidget(0, 0, 148, 22, (ITextComponent)Blocks.field_150331_J.func_235333_g_()));
            w = new ProperToggleWidget(0, 0, 22, 22, 100, 167, 22, 0, TEXTURE, "info.craftabledeeds.can_edit_world", claim.canPistonsPush, v -> {
                claim.canPistonsPush = v;
                PacketHandler.sendGeneralSettings(claim);
            });
            ret.add((Object)w);
            allPlaceBreak.add(w);
            claim.playerSettings.values().stream().filter(s -> s.isFake).forEach(s -> ret.addAll(Tab.createPlayerRow(screen, s, allPlaceBreak, null, null)));
            ret.add(0, (Object)new TextWidget(0, 0, 148, 22, (ITextComponent)new TranslationTextComponent("info.craftabledeeds.set_all")));
            ret.add(1, (Object)new ProperToggleWidget(0, 0, 22, 22, 100, 167, 22, 0, TEXTURE, "info.craftabledeeds.can_edit_world", allPlaceBreak.stream().allMatch(ToggleWidget::func_191754_c), v -> allPlaceBreak.forEach(x -> x.func_191753_b((boolean)v))));
            return ret;
        }, 2);

        public final Function<DeedPedestalScreen, List<Widget>> init;
        public final int widgetAmountX;

        private Tab(Function<DeedPedestalScreen, List<Widget>> init, int widgetAmountX) {
            this.init = init;
            this.widgetAmountX = widgetAmountX;
        }

        private static List<Widget> createPlayerRow(DeedPedestalScreen screen, DeedStorage.PlayerSettings settings, List<ProperToggleWidget> allPlaceBreak, List<ProperToggleWidget> allLoyalAttack, List<ProperToggleWidget> allContainers) {
            DeedStorage.Claim claim = ((DeedPedestalContainer)((DeedPedestalScreen)screen).field_147002_h).tile.getClaim();
            ArrayList<Widget> widgets = new ArrayList<Widget>();
            widgets.add(new TextWidget(0, 0, 148, 22, (ITextComponent)new StringTextComponent(settings.name)));
            ProperToggleWidget w = new ProperToggleWidget(0, 0, 22, 22, 100, 167, 22, 0, TEXTURE, "info.craftabledeeds.can_place_break", settings.canPlaceBreak, v -> {
                settings.canPlaceBreak = v;
                PacketHandler.sendPlayerSettings(settings, claim);
            });
            widgets.add((Widget)w);
            allPlaceBreak.add(w);
            if (!settings.isFake) {
                w = new ProperToggleWidget(0, 0, 22, 22, 100, 190, 22, 0, TEXTURE, "info.craftabledeeds.loyal_mobs_attack", settings.loyalMobsAttack, v -> {
                    settings.loyalMobsAttack = v;
                    PacketHandler.sendPlayerSettings(settings, claim);
                });
                widgets.add((Widget)w);
                if (allLoyalAttack != null) {
                    allLoyalAttack.add(w);
                }
                w = new ProperToggleWidget(0, 0, 22, 22, 100, 213, 22, 0, TEXTURE, "info.craftabledeeds.can_open_containers", settings.canOpenContainers, v -> {
                    settings.canOpenContainers = v;
                    PacketHandler.sendPlayerSettings(settings, claim);
                });
                widgets.add((Widget)w);
                if (allContainers != null) {
                    allContainers.add(w);
                }
            }
            return widgets;
        }
    }

    private class TabWidget
    extends AbstractButton {
        private final Tab tab;
        private final int u;
        private final int v;

        public TabWidget(int x, int y, int width, int height, int u, int v, Tab tab) {
            super(x, y, width, height, (ITextComponent)new TranslationTextComponent("tab.craftabledeeds." + tab.name().toLowerCase(Locale.ROOT)));
            this.u = u;
            this.v = v;
            this.tab = tab;
        }

        public void func_230930_b_() {
            DeedPedestalScreen.this.scrollOffset = 0;
            DeedPedestalScreen.this.setTab(this.tab);
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            int v = this.v;
            if (DeedPedestalScreen.this.currentTab == this.tab) {
                v += this.field_230689_k_;
            }
            RenderSystem.enableDepthTest();
            TabWidget.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.u, (float)v, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)256, (int)256);
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            DeedPedestalScreen.this.func_238652_a_(matrixStack, this.func_230458_i_(), mouseX, mouseY);
        }
    }
}

