/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.biome;

import jpg.k.simplyimprovedterrain.biome.blending.LinkedBiomeWeightMap;
import jpg.k.simplyimprovedterrain.biome.blending.ScatteredBiomeBlender;
import jpg.k.simplyimprovedterrain.util.LinkedHashCache;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.IBiomeMagnifier;

public enum CachedScatteredBiomeMagnifier implements IBiomeMagnifier
{
    INSTANCE;

    private static final int N_ACTIVEMOST_NODES = 8;
    private static final int CACHE_MAX_SIZE = 24;
    private static final double SCATTERED_BLENDER_FREQUENCY = 0.078125;
    private static final double SCATTERED_BLENDER_PADDING = 4.0;
    private static final ScatteredBiomeBlender scatteredBiomeBlender;
    private static final int gridPadding;
    private static final int paddedGridWidth;
    private static final int paddedGridWidthSq;
    private static LinkedHashCache<ProviderCoordinate, Biome[]> cache;

    private void CachedScatteredBiomeMagnifier() {
    }

    public Biome func_225532_a_(long seed, int x, int y, int z, BiomeManager.IBiomeReader biomeReader) {
        ProviderCoordinate key = new ProviderCoordinate(biomeReader, seed, x & 0xFFFFFFF0, z & 0xFFFFFFF0);
        Biome[] biomes = cache.get(key, CachedScatteredBiomeMagnifier::generateBiomes);
        Biome biome = biomes.length != 1 ? biomes[(z & 0xF) << 4 | x & 0xF] : biomes[0];
        return biome;
    }

    private static Biome[] generateBiomes(ProviderCoordinate key) {
        LinkedBiomeWeightMap startEntry = CachedScatteredBiomeMagnifier.generateBiomeBlending(key.biomeReader, key.seed, key.x, key.z);
        return CachedScatteredBiomeMagnifier.generateBiomes(startEntry);
    }

    private static Biome[] generateBiomes(LinkedBiomeWeightMap startEntry) {
        if (startEntry.getNext() != null) {
            Biome[] biomes = new Biome[256];
            for (int i = 0; i < 256; ++i) {
                double bestWeight = Double.NEGATIVE_INFINITY;
                Biome bestBiome = null;
                for (LinkedBiomeWeightMap entry = startEntry; entry != null; entry = entry.getNext()) {
                    double thisWeight = entry.getWeights()[i];
                    if (!(thisWeight > bestWeight)) continue;
                    bestWeight = thisWeight;
                    bestBiome = entry.getBiome();
                }
                biomes[i] = bestBiome;
            }
            return biomes;
        }
        return new Biome[]{startEntry.getBiome()};
    }

    private static LinkedBiomeWeightMap generateBiomeBlending(BiomeManager.IBiomeReader biomeReader, long seed, int worldChunkX, int worldChunkZ) {
        int worldChunkXScaled = worldChunkX >> 2;
        int worldChunkZScaled = worldChunkZ >> 2;
        Biome[] lookupGrid = new Biome[paddedGridWidthSq];
        for (int z2 = 0; z2 < paddedGridWidth; ++z2) {
            for (int x2 = 0; x2 < paddedGridWidth; ++x2) {
                lookupGrid[z2 * CachedScatteredBiomeMagnifier.paddedGridWidth + x2] = biomeReader.func_225526_b_(x2 + (worldChunkXScaled - gridPadding), 0, z2 + (worldChunkZScaled - gridPadding));
            }
        }
        return scatteredBiomeBlender.getBlendForChunk(0L, worldChunkX, worldChunkZ, (x, z) -> {
            int xRound = (int)(x > 0.0 ? x + 0.5 : (x *= 0.25) - 0.5);
            int zRound = (int)(z > 0.0 ? z + 0.5 : (z *= 0.25) - 0.5);
            int lxRound = xRound + (gridPadding - worldChunkXScaled);
            int lzRound = zRound + (gridPadding - worldChunkZScaled);
            Biome biome = lookupGrid[lzRound * paddedGridWidth + lxRound];
            double closestRiverTileDistSq = Double.POSITIVE_INFINITY;
            for (int rz = zRound - 2; rz <= zRound + 2; ++rz) {
                int b = rz > zRound - 2 && rz < zRound + 2 ? 2 : 1;
                for (int rx = xRound - b; rx <= xRound + b; ++rx) {
                    Biome thisBiome;
                    double distSq = ((double)rz - z) * ((double)rz - z) + ((double)rx - x) * ((double)rx - x);
                    if (distSq >= closestRiverTileDistSq || (thisBiome = lookupGrid[(rz + (gridPadding - worldChunkZScaled)) * paddedGridWidth + (rx + (gridPadding - worldChunkXScaled))]).func_201856_r() != Biome.Category.RIVER) continue;
                    biome = thisBiome;
                    closestRiverTileDistSq = distSq;
                }
            }
            return biome;
        });
    }

    public static LinkedBiomeWeightMap generateBiomeBlendingAndCacheMap(BiomeManager.IBiomeReader biomeReader, long seed, int worldChunkX, int worldChunkZ) {
        LinkedBiomeWeightMap startEntry = CachedScatteredBiomeMagnifier.generateBiomeBlending(biomeReader, seed, worldChunkX, worldChunkZ);
        ProviderCoordinate key = new ProviderCoordinate(biomeReader, seed, worldChunkX, worldChunkZ);
        cache.get(key, k -> CachedScatteredBiomeMagnifier.generateBiomes(startEntry));
        return startEntry;
    }

    static {
        scatteredBiomeBlender = new ScatteredBiomeBlender(0.078125, 4.0, 16);
        gridPadding = (int)Math.ceil(scatteredBiomeBlender.getInternalBlendRadius() * 0.25) + 3;
        paddedGridWidth = 5 + 2 * gridPadding;
        paddedGridWidthSq = paddedGridWidth * paddedGridWidth;
        cache = new LinkedHashCache(8, 24);
    }

    private static class ProviderCoordinate {
        BiomeManager.IBiomeReader biomeReader;
        long seed;
        int x;
        int z;

        public ProviderCoordinate(BiomeManager.IBiomeReader biomeReader, long seed, int x, int z) {
            this.biomeReader = biomeReader;
            this.seed = seed;
            this.x = x;
            this.z = z;
        }

        public int hashCode() {
            return Long.hashCode(this.seed) ^ this.x * 509 ^ this.z * 2591 ^ System.identityHashCode(this.biomeReader) * 515153;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProviderCoordinate)) {
                return false;
            }
            ProviderCoordinate o = (ProviderCoordinate)other;
            return this.biomeReader == o.biomeReader && this.seed == o.seed && this.x == o.x && this.z == o.z;
        }
    }
}

