/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.biome.blending;

import java.util.List;
import jpg.k.simplyimprovedterrain.biome.blending.LinkedBiomeWeightMap;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.ChunkPointGatherer;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.GatheredPoint;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.UnfilteredPointGatherer;
import net.minecraft.world.biome.Biome;

public class ScatteredBiomeBlender {
    private final int chunkColumnCount;
    private final int blendRadiusBoundArrayCenter;
    private final double chunkWidthMinusOne;
    private final double blendRadius;
    private final double blendRadiusSq;
    private final double[] blendRadiusBound;
    private final ChunkPointGatherer<LinkedBiomeWeightMap> gatherer;

    public ScatteredBiomeBlender(double samplingFrequency, double blendRadiusPadding, int chunkWidth) {
        this.chunkWidthMinusOne = chunkWidth - 1;
        this.chunkColumnCount = chunkWidth * chunkWidth;
        this.blendRadius = blendRadiusPadding + ScatteredBiomeBlender.getInternalMinBlendRadiusForFrequency(samplingFrequency);
        this.blendRadiusSq = this.blendRadius * this.blendRadius;
        this.gatherer = new ChunkPointGatherer(samplingFrequency, this.blendRadius, chunkWidth);
        this.blendRadiusBoundArrayCenter = (int)Math.ceil(this.blendRadius) - 1;
        this.blendRadiusBound = new double[this.blendRadiusBoundArrayCenter * 2 + 1];
        for (int i = 0; i < this.blendRadiusBound.length; ++i) {
            int dx = i - this.blendRadiusBoundArrayCenter;
            int maxDxBeforeTruncate = Math.abs(dx) + 1;
            this.blendRadiusBound[i] = Math.sqrt(this.blendRadiusSq - (double)maxDxBeforeTruncate);
        }
    }

    public LinkedBiomeWeightMap getBlendForChunk(long seed, int chunkBaseWorldX, int chunkBaseWorldZ, BiomeEvaluationCallback callback) {
        double x;
        List<GatheredPoint<LinkedBiomeWeightMap>> points = this.gatherer.getPointsFromChunkBase(seed, chunkBaseWorldX, chunkBaseWorldZ);
        LinkedBiomeWeightMap linkedBiomeMapStartEntry = null;
        for (GatheredPoint<LinkedBiomeWeightMap> point : points) {
            LinkedBiomeWeightMap entry;
            Biome biome = callback.getBiomeAt(point.getX(), point.getZ());
            for (entry = linkedBiomeMapStartEntry; entry != null && !entry.getBiome().equals(biome); entry = entry.getNext()) {
            }
            if (entry == null) {
                entry = linkedBiomeMapStartEntry = new LinkedBiomeWeightMap(biome, linkedBiomeMapStartEntry);
            }
            point.setTag(entry);
        }
        if (linkedBiomeMapStartEntry != null && linkedBiomeMapStartEntry.getNext() == null) {
            return linkedBiomeMapStartEntry;
        }
        for (LinkedBiomeWeightMap entry = linkedBiomeMapStartEntry; entry != null; entry = entry.getNext()) {
            entry.setWeights(new double[this.chunkColumnCount]);
        }
        double z = chunkBaseWorldZ;
        double xStart = x = (double)chunkBaseWorldX;
        double xEnd = xStart + this.chunkWidthMinusOne;
        for (int i = 0; i < this.chunkColumnCount; ++i) {
            double columnTotalWeight = 0.0;
            for (GatheredPoint<LinkedBiomeWeightMap> point : points) {
                double dz;
                double dx = x - point.getX();
                double distSq = dx * dx + (dz = z - point.getZ()) * dz;
                if (!(distSq < this.blendRadiusSq)) continue;
                double weight = this.blendRadiusSq - distSq;
                weight *= weight;
                double[] dArray = point.getTag().getWeights();
                int n = i;
                dArray[n] = dArray[n] + weight;
                columnTotalWeight += weight;
            }
            double inverseTotalWeight = 1.0 / columnTotalWeight;
            for (LinkedBiomeWeightMap entry = linkedBiomeMapStartEntry; entry != null; entry = entry.getNext()) {
                double[] dArray = entry.getWeights();
                int n = i;
                dArray[n] = dArray[n] * inverseTotalWeight;
            }
            if (x == xEnd) {
                x = xStart;
                z += 1.0;
                continue;
            }
            x += 1.0;
        }
        return linkedBiomeMapStartEntry;
    }

    public static double getInternalMinBlendRadiusForFrequency(double samplingFrequency) {
        return UnfilteredPointGatherer.MAX_GRIDSCALE_DISTANCE_TO_CLOSEST_POINT / samplingFrequency;
    }

    public double getInternalBlendRadius() {
        return this.blendRadius;
    }

    @FunctionalInterface
    public static interface BiomeEvaluationCallback {
        public Biome getBiomeAt(double var1, double var3);
    }
}

