/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jpg.k.simplyimprovedterrain.biome.CachedScatteredBiomeMagnifier;
import jpg.k.simplyimprovedterrain.biome.blending.LinkedBiomeWeightMap;
import jpg.k.simplyimprovedterrain.biome.blending.ScatteredBiomeBlender;
import jpg.k.simplyimprovedterrain.mixinapi.ISimplexNoiseGenerator;
import jpg.k.simplyimprovedterrain.util.noise.MetaballEndIslandNoise;
import jpg.k.simplyimprovedterrain.util.noise.NeoNotchNoise;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.NoiseSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseChunkGenerator.class})
public class MixinNoiseChunkGenerator {
    private static final double NOISE_MAIN_FREQUENCY = 0.0208865966796875;
    private static final double BLEND_NOISE_RELATIVE_FREQUENCY = 256.0;
    private static final double PRIMARY_NOISE_MAIN_AMPLITUDE = 64.0;
    private static final double BLEND_NOISE_MAIN_AMPLITUDE = 6.4;
    private static final int N_OCTAVES_PRIMARY = 6;
    private static final int N_OCTAVES_BLEND = 3;
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    @Shadow
    protected Supplier<DimensionSettings> field_236080_h_;
    @Shadow
    private int field_222563_j;
    @Shadow
    private int field_222564_k;
    @Shadow
    private int field_222566_m;
    @Shadow
    public long field_236084_w_;
    @Shadow
    protected SharedSeedRandom field_222558_e;
    @Shadow
    private int field_236085_x_;
    @Shadow
    private SimplexNoiseGenerator field_236083_v_;
    private NeoNotchNoise[] newNoiseOctaves1;
    private NeoNotchNoise[] newNoiseOctaves2;
    private NeoNotchNoise[] newNoiseOctavesBlend;
    private double[] primaryUncertaintyBounds;
    private double[] blendUncertaintyBounds;
    private BiomeProvider biomeSource;
    private int seaLevel;
    private double inverseVerticalNoiseResolution;
    private double inverseHorizontalNoiseResolution;
    private double noiseXZScale;
    private double noiseYScale;
    private double blendNoiseXZScale;
    private double blendNoiseYScale;
    private double ratioFrequencyToSmooth;
    private double effectiveThresholdMultiplier;
    private double effectiveThresholdOffset;
    private double[] thresholdSlideModifiers;
    private int effectiveBiomeBlurKernelRadius;
    private float[] biomeBlurKernel;
    private float[] biomeBlurKernel2;
    private ScatteredBiomeBlender scatteredBiomeBlender;
    private NoiseSettings generationShapeConfig;
    boolean useEndIslandNoise;

    @Inject(method={"<init>(Lnet/minecraft/world/biome/provider/BiomeProvider;Lnet/minecraft/world/biome/provider/BiomeProvider;JLjava/util/function/Supplier;)V"}, at={@At(value="TAIL")})
    private void injectConstructor(BiomeProvider biomeSource, BiomeProvider biomeSource2, long worldSeed, Supplier<DimensionSettings> supplier, CallbackInfo cir) {
        int i;
        this.biomeSource = biomeSource;
        DimensionSettings chunkGeneratorSettings = this.field_236080_h_.get();
        NoiseSettings generationShapeConfig = chunkGeneratorSettings.func_236113_b_();
        this.inverseVerticalNoiseResolution = 1.0 / (double)this.field_222563_j;
        this.inverseHorizontalNoiseResolution = 1.0 / (double)this.field_222564_k;
        double thresholdTopSlideTarget = generationShapeConfig.func_236172_c_().func_236186_a_();
        double thresholdTopSlideSize = generationShapeConfig.func_236172_c_().func_236188_b_();
        double thresholdTopSlideOffset = generationShapeConfig.func_236172_c_().func_236189_c_();
        double thresholdBottomSlideTarget = generationShapeConfig.func_236173_d_().func_236186_a_();
        double thresholdBottomSlideSize = generationShapeConfig.func_236173_d_().func_236188_b_();
        double thresholdBottomSlideOffset = generationShapeConfig.func_236173_d_().func_236189_c_();
        this.noiseXZScale = 0.0208865966796875 * generationShapeConfig.func_236171_b_().func_236151_a_() * this.inverseHorizontalNoiseResolution;
        this.noiseYScale = 0.0208865966796875 * generationShapeConfig.func_236171_b_().func_236153_b_() * this.inverseVerticalNoiseResolution * 1.1;
        this.blendNoiseXZScale = 256.0 * this.noiseXZScale / generationShapeConfig.func_236171_b_().func_236154_c_();
        this.blendNoiseYScale = 256.0 * this.noiseYScale / generationShapeConfig.func_236171_b_().func_236155_d_();
        this.ratioFrequencyToSmooth = Math.sqrt(3.0) * 0.5 * (double)this.field_222563_j;
        this.seaLevel = chunkGeneratorSettings.func_236119_g_();
        this.newNoiseOctaves1 = new NeoNotchNoise[6];
        this.newNoiseOctaves2 = new NeoNotchNoise[6];
        this.newNoiseOctavesBlend = new NeoNotchNoise[3];
        for (int i2 = 0; i2 < Math.max(6, 3); ++i2) {
            if (i2 < 6) {
                this.newNoiseOctaves1[i2] = new NeoNotchNoise((Random)this.field_222558_e);
                this.newNoiseOctaves2[i2] = new NeoNotchNoise((Random)this.field_222558_e);
            }
            if (i2 >= 3) continue;
            this.newNoiseOctavesBlend[i2] = new NeoNotchNoise((Random)this.field_222558_e);
        }
        this.primaryUncertaintyBounds = new double[6];
        double maxValueSum = 0.0;
        for (i = 5; i >= 0; --i) {
            this.primaryUncertaintyBounds[i] = 64.0 * (maxValueSum += 1.0 / (double)(1 << i));
        }
        this.blendUncertaintyBounds = new double[3];
        maxValueSum = 0.0;
        for (i = 2; i >= 0; --i) {
            this.blendUncertaintyBounds[i] = 6.4 * (maxValueSum += 1.0 / (double)(1 << i)) + 0.5;
        }
        this.scatteredBiomeBlender = new ScatteredBiomeBlender(0.3125 * this.inverseHorizontalNoiseResolution, this.field_222564_k, 16);
        this.generationShapeConfig = this.field_236080_h_.get().func_236113_b_();
        double twiceInverseWorldHeight = 2.0 / (double)generationShapeConfig.func_236169_a_();
        double thresholdMultiplier = generationShapeConfig.func_236176_g_();
        double thresholdOffset = generationShapeConfig.func_236177_h_();
        this.effectiveThresholdMultiplier = -twiceInverseWorldHeight * thresholdMultiplier;
        this.effectiveThresholdOffset = thresholdMultiplier + thresholdOffset;
        int generationHeight = generationShapeConfig.func_236169_a_();
        this.thresholdSlideModifiers = new double[generationHeight];
        for (int y = 0; y < generationHeight; ++y) {
            double inverseT;
            double tBase;
            double thresholdSlideModifier = 0.0;
            double yb = (double)y * this.inverseVerticalNoiseResolution;
            if (thresholdTopSlideSize > 0.0 && (tBase = (double)this.field_222566_m - yb - thresholdTopSlideOffset) < thresholdTopSlideSize) {
                if (tBase < 0.0) {
                    tBase = 0.0;
                }
                inverseT = thresholdTopSlideSize / tBase;
                thresholdSlideModifier += thresholdTopSlideTarget * (inverseT - 1.0);
            }
            if (thresholdBottomSlideSize > 0.0 && (tBase = yb - thresholdBottomSlideOffset) < thresholdBottomSlideSize) {
                if (tBase < 0.0) {
                    tBase = 0.0;
                }
                inverseT = thresholdBottomSlideSize / tBase;
                thresholdSlideModifier += thresholdBottomSlideTarget * (inverseT - 1.0);
            }
            this.thresholdSlideModifiers[y] = thresholdSlideModifier;
        }
        this.useEndIslandNoise = generationShapeConfig.func_236180_k_();
    }

    private double computeNecessaryNoiseOctaves(int worldX, int worldY, int worldZ, double startingValue) {
        double amp;
        double freqY;
        double freqXZ;
        int octave;
        double signValue = startingValue;
        if (signValue > this.primaryUncertaintyBounds[0] || signValue < -this.primaryUncertaintyBounds[0]) {
            return signValue;
        }
        double blendingValue = 0.0;
        if (this.newNoiseOctavesBlend.length != 0) {
            octave = 0;
            freqXZ = this.blendNoiseXZScale;
            freqY = this.blendNoiseYScale;
            amp = 6.4;
            do {
            } while (++octave < this.newNoiseOctavesBlend.length && (blendingValue += this.newNoiseOctavesBlend[octave].noise3((double)worldX * (freqXZ *= 2.0), (double)worldY * (freqY *= 2.0), (double)worldZ * freqXZ, freqY * this.ratioFrequencyToSmooth) * (amp /= 2.0)) > -this.blendUncertaintyBounds[octave] && blendingValue < this.blendUncertaintyBounds[octave]);
            if (blendingValue <= -0.5) {
                blendingValue = 0.0;
            } else if (blendingValue >= 0.5) {
                blendingValue = 1.0;
            } else {
                blendingValue += 0.5;
                blendingValue = blendingValue * blendingValue * (3.0 - blendingValue * 2.0);
            }
        }
        octave = 0;
        freqXZ = this.noiseXZScale;
        freqY = this.noiseYScale;
        amp = 64.0;
        do {
            if (blendingValue < 1.0) {
                signValue += (1.0 - blendingValue) * amp * this.newNoiseOctaves1[octave].noise3((double)worldX * freqXZ, (double)worldY * freqY, (double)worldZ * freqXZ, freqY * this.ratioFrequencyToSmooth);
            }
            if (blendingValue > 0.0) {
                signValue += blendingValue * amp * this.newNoiseOctaves2[octave].noise3((double)worldX * freqXZ, (double)worldY * freqY, (double)worldZ * freqXZ, freqY * this.ratioFrequencyToSmooth);
            }
            freqXZ *= 2.0;
            freqY *= 2.0;
            amp /= 2.0;
        } while (++octave < this.newNoiseOctaves1.length && signValue > -this.primaryUncertaintyBounds[octave] && signValue < this.primaryUncertaintyBounds[octave]);
        return signValue;
    }

    private double[][][] getBlendedBiomeMap(int worldChunkX, int worldChunkZ) {
        double[][] biomeBlendValues1 = new double[16][16];
        double[][] biomeBlendValues2 = new double[16][16];
        if (this.useEndIslandNoise) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    double depth;
                    biomeBlendValues1[z][x] = depth = MetaballEndIslandNoise.INSTANCE.getNoise(((ISimplexNoiseGenerator)this.field_236083_v_).getPermTable(), worldChunkX + x, worldChunkZ + z);
                    biomeBlendValues2[z][x] = depth > 0.0 ? 0.25 : 1.0;
                }
            }
        } else {
            LinkedBiomeWeightMap weightMap = CachedScatteredBiomeMagnifier.generateBiomeBlendingAndCacheMap((BiomeManager.IBiomeReader)this.biomeSource, BiomeManager.func_235200_a_((long)this.field_236084_w_), worldChunkX, worldChunkZ);
            if (weightMap.getWeights() == null) {
                Biome biome = weightMap.getBiome();
                float biomeDepth = biome.func_185355_j();
                float biomeScale = biome.func_185360_m();
                if (this.generationShapeConfig.func_236181_l_() && biomeDepth > 0.0f) {
                    biomeDepth = 1.0f + biomeDepth * 2.0f;
                    biomeScale = 1.0f + biomeScale * 4.0f;
                }
                double effectiveDepth = (double)(biomeDepth * 0.5f - 0.125f) * 0.265625;
                double effectiveScale = 96.0 / (double)(biomeScale * 0.9f + 0.1f);
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        biomeBlendValues1[z][x] = effectiveDepth;
                        biomeBlendValues2[z][x] = effectiveScale;
                    }
                }
            } else {
                do {
                    Biome biome = weightMap.getBiome();
                    float biomeDepth = biome.func_185355_j();
                    float biomeScale = biome.func_185360_m();
                    if (this.generationShapeConfig.func_236181_l_() && biomeDepth > 0.0f) {
                        biomeDepth = 1.0f + biomeDepth * 2.0f;
                        biomeScale = 1.0f + biomeScale * 4.0f;
                    }
                    double effectiveDepth = (double)(biomeDepth * 0.5f - 0.125f) * 0.265625;
                    double effectiveScale = 96.0 / (double)(biomeScale * 0.9f + 0.1f);
                    effectiveDepth *= effectiveScale;
                    for (int z = 0; z < 16; ++z) {
                        int x = 0;
                        while (x < 16) {
                            double weight = weightMap.getWeights()[z * 16 + x];
                            double[] dArray = biomeBlendValues1[z];
                            int n = x;
                            dArray[n] = dArray[n] + weight * effectiveDepth;
                            double[] dArray2 = biomeBlendValues2[z];
                            int n2 = x++;
                            dArray2[n2] = dArray2[n2] + weight * effectiveScale;
                        }
                    }
                } while ((weightMap = weightMap.getNext()) != null);
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        double[] dArray = biomeBlendValues1[z];
                        int n = x;
                        dArray[n] = dArray[n] / biomeBlendValues2[z][x];
                    }
                }
            }
        }
        return new double[][][]{biomeBlendValues1, biomeBlendValues2};
    }

    @Inject(method={"func_236087_a_"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectSampleHeightmap(int x, int z, BlockState[] states, Predicate<BlockState> predicate, CallbackInfoReturnable<Integer> cir) {
        double[][][] blendedBiomeMap = this.getBlendedBiomeMap(x, z);
        for (int y = this.field_236085_x_ - 1; y >= 0; --y) {
            double thresholdingValue = (double)y * this.effectiveThresholdMultiplier + this.effectiveThresholdOffset;
            if ((thresholdingValue = (thresholdingValue + blendedBiomeMap[0][z & 0xF][x & 0xF]) * blendedBiomeMap[1][z & 0xF][x & 0xF]) > 0.0) {
                thresholdingValue *= 4.0;
            }
            double noiseValue = this.computeNecessaryNoiseOctaves(x, y, z, thresholdingValue += this.thresholdSlideModifiers[y]);
            BlockState blockState = this.func_236086_a_(noiseValue, y);
            if (states != null) {
                states[y] = blockState;
            }
            if (predicate == null || !predicate.test(blockState)) continue;
            cir.setReturnValue((Object)(y + 1));
            cir.cancel();
            return;
        }
        cir.setReturnValue((Object)0);
        cir.cancel();
    }

    @Shadow
    protected BlockState func_236086_a_(double density, int y) {
        throw new AssertionError();
    }

    @Shadow
    private static double func_222556_a(int x, int y, int z) {
        throw new AssertionError();
    }

    @Inject(method={"func_230352_b_"}, at={@At(value="HEAD")}, cancellable=true)
    public void populateNoise(IWorld world, StructureManager accessor, IChunk chunk, CallbackInfo callbackInfo) {
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkPos = chunk.func_76632_l();
        int i = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        int k = i << 4;
        int l = j << 4;
        for (Structure structure : Structure.field_236384_t_) {
            accessor.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkPos, (int)0), structure).forEach(arg_0 -> MixinNoiseChunkGenerator.lambda$populateNoise$0(chunkPos, (ObjectList)objectlist, k, l, (ObjectList)objectlist1, arg_0));
        }
        NoiseSettings generationShapeConfig = this.field_236080_h_.get().func_236113_b_();
        double[][][] blendedBiomeMap = this.getBlendedBiomeMap(k, l);
        ChunkPrimer protoChunk = (ChunkPrimer)chunk;
        Heightmap oceanFloorHeightmap = protoChunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap worldSurfaceHeightmap = protoChunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable blockPosMutable = new BlockPos.Mutable();
        ObjectListIterator villagePieceIterator = objectlist.iterator();
        ObjectListIterator jigsawJunctionIterator = objectlist1.iterator();
        ChunkSection chunksection = protoChunk.func_217332_a(this.field_236085_x_ - 1 >> 4);
        chunksection.func_222635_a();
        for (int y = this.field_236085_x_ - 1; y >= 0; --y) {
            int chunkSectionIndex = y >> 4;
            int chunkSectionY = y & 0xF;
            if (chunksection.func_222632_g() >> 4 != chunkSectionIndex) {
                chunksection.func_222637_b();
                chunksection = protoChunk.func_217332_a(chunkSectionIndex);
                chunksection.func_222635_a();
            }
            for (int z = 0; z < 16; ++z) {
                int worldZ = l | z;
                for (int x = 0; x < 16; ++x) {
                    BlockState blockState;
                    double noiseSignValue;
                    int worldX = k | x;
                    double thresholdingValue = (double)y * this.effectiveThresholdMultiplier + this.effectiveThresholdOffset;
                    if ((thresholdingValue = (thresholdingValue + blendedBiomeMap[0][z][x]) * blendedBiomeMap[1][z][x]) > 0.0) {
                        thresholdingValue *= 4.0;
                    }
                    if ((noiseSignValue = this.computeNecessaryNoiseOctaves(worldX, y, worldZ, thresholdingValue += this.thresholdSlideModifiers[y])) != thresholdingValue) {
                        int vYBound;
                        int vXBound;
                        noiseSignValue = MathHelper.func_151237_a((double)(noiseSignValue / 200.0), (double)-1.0, (double)1.0);
                        noiseSignValue = noiseSignValue / 2.0 - noiseSignValue * noiseSignValue * noiseSignValue / 24.0;
                        while (villagePieceIterator.hasNext()) {
                            StructurePiece structurePiece = (StructurePiece)villagePieceIterator.next();
                            MutableBoundingBox blockBox = structurePiece.func_74874_b();
                            vXBound = Math.max(0, Math.max(blockBox.field_78897_a - worldX, worldX - blockBox.field_78893_d));
                            vYBound = y - (blockBox.field_78895_b + (structurePiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurePiece).func_214830_d() : 0));
                            int vZBound = Math.max(0, Math.max(blockBox.field_78896_c - worldZ, worldZ - blockBox.field_78892_f));
                            noiseSignValue += MixinNoiseChunkGenerator.func_222556_a(vXBound, vYBound, vZBound) * 0.8;
                        }
                        villagePieceIterator.back(objectlist.size());
                        while (jigsawJunctionIterator.hasNext()) {
                            JigsawJunction jigsawJunction = (JigsawJunction)jigsawJunctionIterator.next();
                            int as = worldX - jigsawJunction.func_214895_a();
                            vXBound = y - jigsawJunction.func_214896_b();
                            vYBound = worldZ - jigsawJunction.func_214893_c();
                            noiseSignValue += MixinNoiseChunkGenerator.func_222556_a(as, vXBound, vYBound) * 0.4;
                        }
                        jigsawJunctionIterator.back(objectlist1.size());
                    }
                    if ((blockState = this.func_236086_a_(noiseSignValue, y)) == AIR) continue;
                    if (blockState.getLightValue((IBlockReader)protoChunk, (BlockPos)blockPosMutable) != 0) {
                        blockPosMutable.func_181079_c(worldX, y, worldZ);
                        protoChunk.func_201637_h((BlockPos)blockPosMutable);
                    }
                    chunksection.func_177484_a(x, chunkSectionY, z, blockState, false);
                    oceanFloorHeightmap.func_202270_a(x, y, z, blockState);
                    worldSurfaceHeightmap.func_202270_a(x, y, z, blockState);
                }
            }
        }
        chunksection.func_222637_b();
        callbackInfo.cancel();
    }

    private static /* synthetic */ void lambda$populateNoise$0(ChunkPos chunkPos, ObjectList objectlist, int k, int l, ObjectList objectlist1, StructureStart p_236089_5_) {
        for (StructurePiece structurepiece1 : p_236089_5_.func_186161_c()) {
            if (!structurepiece1.func_214810_a(chunkPos, 12)) continue;
            if (structurepiece1 instanceof AbstractVillagePiece) {
                AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece1;
                JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectlist.add((Object)abstractvillagepiece);
                }
                for (JigsawJunction jigsawjunction1 : abstractvillagepiece.func_214829_e()) {
                    int l5 = jigsawjunction1.func_214895_a();
                    int i6 = jigsawjunction1.func_214893_c();
                    if (l5 <= k - 12 || i6 <= l - 12 || l5 >= k + 15 + 12 || i6 >= l + 15 + 12) continue;
                    objectlist1.add((Object)jigsawjunction1);
                }
                continue;
            }
            objectlist.add((Object)structurepiece1);
        }
    }
}

