/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class LinkedHashCache<K, V> {
    private final int nActivemostNodes;
    private final int maxCacheSize;
    private final ConcurrentHashMap<K, LinkedCacheEntry<K, V>> cacheMap;
    private final ReentrantLock linkedCacheLock;
    private LinkedCacheEntry<K, V> lowestCacheEntry;
    private LinkedCacheEntry<K, V> highestCacheEntry;
    private int cacheSize;
    private int frontNodeNumber;

    public LinkedHashCache(int nActivemostNodes, int maxCacheSize) {
        this.nActivemostNodes = nActivemostNodes;
        this.maxCacheSize = maxCacheSize;
        this.cacheMap = new ConcurrentHashMap();
        this.linkedCacheLock = new ReentrantLock();
        this.cacheSize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Function<K, V> generateValue) {
        LinkedCacheEntry entry = this.cacheMap.computeIfAbsent(key, k -> {
            LinkedCacheEntry newEntry = new LinkedCacheEntry();
            this.linkedCacheLock.lock();
            try {
                ++this.cacheSize;
                ++this.frontNodeNumber;
                newEntry.nodeNumber = this.frontNodeNumber;
                if (this.highestCacheEntry != null) {
                    this.highestCacheEntry.next = newEntry;
                    newEntry.prev = this.highestCacheEntry;
                } else {
                    this.lowestCacheEntry = newEntry;
                }
                this.highestCacheEntry = newEntry;
            }
            finally {
                this.linkedCacheLock.unlock();
            }
            newEntry.key = k;
            newEntry.value = generateValue.apply(k);
            return newEntry;
        });
        if ((this.cacheSize >= this.maxCacheSize || this.frontNodeNumber - entry.nodeNumber >= this.nActivemostNodes) && this.linkedCacheLock.tryLock()) {
            try {
                if (this.cacheSize >= this.maxCacheSize) {
                    this.cacheMap.remove(this.lowestCacheEntry.key);
                    this.lowestCacheEntry = this.lowestCacheEntry.next;
                    this.lowestCacheEntry.prev = null;
                    --this.cacheSize;
                }
                if (entry.next != null && this.frontNodeNumber - entry.nodeNumber >= this.nActivemostNodes) {
                    LinkedCacheEntry a = entry.prev;
                    LinkedCacheEntry b = entry;
                    LinkedCacheEntry c = entry.next;
                    LinkedCacheEntry d = c.next;
                    int bNodeNumber = b.nodeNumber;
                    int cNodeNumber = c.nodeNumber;
                    if (a != null) {
                        a.next = c;
                    } else {
                        this.lowestCacheEntry = c;
                    }
                    c.prev = a;
                    c.next = b;
                    c.nodeNumber = bNodeNumber;
                    b.prev = c;
                    b.next = d;
                    b.nodeNumber = cNodeNumber;
                    if (d != null) {
                        d.prev = b;
                    } else {
                        this.highestCacheEntry = b;
                    }
                }
            }
            finally {
                this.linkedCacheLock.unlock();
            }
        }
        return entry.value;
    }

    private static class LinkedCacheEntry<K, V> {
        K key;
        V value;
        int nodeNumber;
        LinkedCacheEntry<K, V> prev;
        LinkedCacheEntry<K, V> next;

        private LinkedCacheEntry() {
        }
    }
}

