/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.util.noise;

import java.util.ArrayList;

public class MetaballEndIslandNoise {
    private static final double TRIANGLE_EDGE_LENGTH = Math.sqrt(0.6666666666666666);
    private static final double TRIANGLE_HEIGHT = Math.sqrt(0.5);
    private static final double TRIANGLE_CIRCUMRADIUS = TRIANGLE_HEIGHT * 0.6666666666666666;
    private static final double OUTPUT_MAX = 100.0;
    private static final double OUTPUT_MIN = -100.0;
    private static final double OUTPUT_RESCALE = 200.0;
    private static final double RADIUS_MULTIPLIER_INVERSE = Math.sqrt(1.0 - Math.pow(0.5, 0.3333333333333333));
    private static final double RADIUS_MULTIPLIER = 1.0 / RADIUS_MULTIPLIER_INVERSE;
    private static final double OUTPUT_CLAMP = 80.0;
    private final double mainIslandRadiusRescaledSqInverse;
    private final double islandRadiusInverseRangeHashMultiplier;
    private final double islandMinRadiusRescaledInverse;
    private final double outerIslandBufferDistanceSq;
    private final double islandFrequency;
    private final LatticePoint[] pointsToSearch;
    private static final double JITTER_AMOUNT = TRIANGLE_EDGE_LENGTH;
    private static final double[] JITTER_VECTORS_128 = new double[]{0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.608761429008721, 0.793353340291235, 0.793353340291235, 0.608761429008721, 0.923879532511287, 0.38268343236509, 0.99144486137381, 0.130526192220051, 0.99144486137381, -0.130526192220051, 0.923879532511287, -0.38268343236509, 0.793353340291235, -0.60876142900872, 0.608761429008721, -0.793353340291235, 0.38268343236509, -0.923879532511287, 0.130526192220052, -0.99144486137381, -0.130526192220052, -0.99144486137381, -0.38268343236509, -0.923879532511287, -0.608761429008721, -0.793353340291235, -0.793353340291235, -0.608761429008721, -0.923879532511287, -0.38268343236509, -0.99144486137381, -0.130526192220052, -0.99144486137381, 0.130526192220051, -0.923879532511287, 0.38268343236509, -0.793353340291235, 0.608761429008721, -0.608761429008721, 0.793353340291235, -0.38268343236509, 0.923879532511287, -0.130526192220052, 0.99144486137381, 0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.608761429008721, 0.793353340291235, 0.793353340291235, 0.608761429008721, 0.923879532511287, 0.38268343236509, 0.99144486137381, 0.130526192220051, 0.99144486137381, -0.130526192220051, 0.923879532511287, -0.38268343236509, 0.793353340291235, -0.60876142900872, 0.608761429008721, -0.793353340291235, 0.38268343236509, -0.923879532511287, 0.130526192220052, -0.99144486137381, -0.130526192220052, -0.99144486137381, -0.38268343236509, -0.923879532511287, -0.608761429008721, -0.793353340291235, -0.793353340291235, -0.608761429008721, -0.923879532511287, -0.38268343236509, -0.99144486137381, -0.130526192220052, -0.99144486137381, 0.130526192220051, -0.923879532511287, 0.38268343236509, -0.793353340291235, 0.608761429008721, -0.608761429008721, 0.793353340291235, -0.38268343236509, 0.923879532511287, -0.130526192220052, 0.99144486137381, 0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.608761429008721, 0.793353340291235, 0.793353340291235, 0.608761429008721, 0.923879532511287, 0.38268343236509, 0.99144486137381, 0.130526192220051, 0.99144486137381, -0.130526192220051, 0.923879532511287, -0.38268343236509, 0.793353340291235, -0.60876142900872, 0.608761429008721, -0.793353340291235, 0.38268343236509, -0.923879532511287, 0.130526192220052, -0.99144486137381, -0.130526192220052, -0.99144486137381, -0.38268343236509, -0.923879532511287, -0.608761429008721, -0.793353340291235, -0.793353340291235, -0.608761429008721, -0.923879532511287, -0.38268343236509, -0.99144486137381, -0.130526192220052, -0.99144486137381, 0.130526192220051, -0.923879532511287, 0.38268343236509, -0.793353340291235, 0.608761429008721, -0.608761429008721, 0.793353340291235, -0.38268343236509, 0.923879532511287, -0.130526192220052, 0.99144486137381, 0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.608761429008721, 0.793353340291235, 0.793353340291235, 0.608761429008721, 0.923879532511287, 0.38268343236509, 0.99144486137381, 0.130526192220051, 0.99144486137381, -0.130526192220051, 0.923879532511287, -0.38268343236509, 0.793353340291235, -0.60876142900872, 0.608761429008721, -0.793353340291235, 0.38268343236509, -0.923879532511287, 0.130526192220052, -0.99144486137381, -0.130526192220052, -0.99144486137381, -0.38268343236509, -0.923879532511287, -0.608761429008721, -0.793353340291235, -0.793353340291235, -0.608761429008721, -0.923879532511287, -0.38268343236509, -0.99144486137381, -0.130526192220052, -0.99144486137381, 0.130526192220051, -0.923879532511287, 0.38268343236509, -0.793353340291235, 0.608761429008721, -0.608761429008721, 0.793353340291235, -0.38268343236509, 0.923879532511287, -0.130526192220052, 0.99144486137381, 0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.608761429008721, 0.793353340291235, 0.793353340291235, 0.608761429008721, 0.923879532511287, 0.38268343236509, 0.99144486137381, 0.130526192220051, 0.99144486137381, -0.130526192220051, 0.923879532511287, -0.38268343236509, 0.793353340291235, -0.60876142900872, 0.608761429008721, -0.793353340291235, 0.38268343236509, -0.923879532511287, 0.130526192220052, -0.99144486137381, -0.130526192220052, -0.99144486137381, -0.38268343236509, -0.923879532511287, -0.608761429008721, -0.793353340291235, -0.793353340291235, -0.608761429008721, -0.923879532511287, -0.38268343236509, -0.99144486137381, -0.130526192220052, -0.99144486137381, 0.130526192220051, -0.923879532511287, 0.38268343236509, -0.793353340291235, 0.608761429008721, -0.608761429008721, 0.793353340291235, -0.38268343236509, 0.923879532511287, -0.130526192220052, 0.99144486137381, 0.38268343236509, 0.923879532511287, 0.923879532511287, 0.38268343236509, 0.923879532511287, -0.38268343236509, 0.38268343236509, -0.923879532511287, -0.38268343236509, -0.923879532511287, -0.923879532511287, -0.38268343236509, -0.923879532511287, 0.38268343236509, -0.38268343236509, 0.923879532511287};
    private static final int[] REMAINING_HASH_LOOKUP = new int[256];
    private static final int REMAINING_HASH_MAX_VALUE = 10;
    public static final MetaballEndIslandNoise INSTANCE;

    public MetaballEndIslandNoise(double mainIslandRadius, double outerIslandMinRadius, double outerIslandMaxRadius, int outerIslandBufferDistance, double islandFrequency) {
        this.mainIslandRadiusRescaledSqInverse = RADIUS_MULTIPLIER_INVERSE * RADIUS_MULTIPLIER_INVERSE / (mainIslandRadius * islandFrequency * (mainIslandRadius * islandFrequency));
        outerIslandBufferDistance = (int)((double)outerIslandBufferDistance + outerIslandMaxRadius);
        this.outerIslandBufferDistanceSq = (double)(outerIslandBufferDistance * outerIslandBufferDistance) * (islandFrequency * islandFrequency);
        this.islandMinRadiusRescaledInverse = RADIUS_MULTIPLIER_INVERSE / (islandFrequency * outerIslandMinRadius);
        double islandMaxRadiusRescaledInverse = RADIUS_MULTIPLIER_INVERSE / (islandFrequency * outerIslandMaxRadius);
        this.islandRadiusInverseRangeHashMultiplier = (islandMaxRadiusRescaledInverse - this.islandMinRadiusRescaledInverse) / 10.0;
        this.islandFrequency = islandFrequency;
        double maxContributingDistance = outerIslandMaxRadius * islandFrequency * RADIUS_MULTIPLIER + (JITTER_AMOUNT + TRIANGLE_CIRCUMRADIUS);
        double maxContributingDistanceSq = maxContributingDistance * maxContributingDistance;
        double latticeSearchRadius = maxContributingDistance / TRIANGLE_HEIGHT;
        ArrayList<LatticePoint> pointsToSearchList = new ArrayList<LatticePoint>();
        pointsToSearchList.add(new LatticePoint(0, 0));
        int i = 1;
        while ((double)i < latticeSearchRadius) {
            LatticePoint point;
            int zsv;
            int xsv = i;
            for (zsv = 0; zsv < i; ++zsv) {
                point = new LatticePoint(xsv, zsv);
                if (!(point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq)) continue;
                pointsToSearchList.add(point);
            }
            while (xsv > 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --xsv;
            }
            while (xsv > -i) {
                point = new LatticePoint(xsv, zsv);
                if (point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --xsv;
                --zsv;
            }
            while (zsv > -i) {
                point = new LatticePoint(xsv, zsv);
                if (point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --zsv;
            }
            while (xsv < 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                ++xsv;
            }
            while (zsv < 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.dx * point.dx + point.dz * point.dz < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                ++xsv;
                ++zsv;
            }
            ++i;
        }
        System.out.println(pointsToSearchList.size());
        this.pointsToSearch = pointsToSearchList.toArray(new LatticePoint[0]);
    }

    public double getNoise(int[] perm256, double x, double z) {
        int zsb;
        double s = ((x *= this.islandFrequency) + (z *= this.islandFrequency)) * 0.366025403784439;
        double xs = x + s;
        double zs = z + s;
        int xsb = (int)xs;
        if (xs < (double)xsb) {
            --xsb;
        }
        if (zs < (double)(zsb = (int)zs)) {
            --zsb;
        }
        double xsi = xs - (double)xsb;
        double zsi = zs - (double)zsb;
        double p = 2.0 * xsi - zsi;
        double q = 2.0 * zsi - xsi;
        double r = xsi + zsi;
        if (r > 1.0) {
            if (p < 0.0) {
                ++zsb;
            } else if (q < 0.0) {
                ++xsb;
            } else {
                ++xsb;
                ++zsb;
            }
        } else if (p > 1.0) {
            ++xsb;
        } else if (q > 1.0) {
            ++zsb;
        }
        xsi = xs - (double)xsb;
        zsi = zs - (double)zsb;
        double t = (xsi + zsi) * -0.211324865405187;
        double xi = xsi + t;
        double zi = zsi + t;
        double value = 1.0 - (x * x + z * z) * this.mainIslandRadiusRescaledSqInverse;
        value = value < 0.0 ? 0.0 : (value *= value * value);
        for (int i = 0; i < this.pointsToSearch.length; ++i) {
            LatticePoint point = this.pointsToSearch[i];
            int xsv = xsb + point.xsv;
            int zsv = zsb + point.zsv;
            int hash = perm256[perm256[xsv & 0xFF] ^ zsv & 0xFF];
            int islandSizeHash = REMAINING_HASH_LOOKUP[hash];
            double islandRadiusInverse = (double)islandSizeHash * this.islandRadiusInverseRangeHashMultiplier + this.islandMinRadiusRescaledInverse;
            double dx = point.dx + xi + JITTER_VECTORS_128[hash & 0xFE];
            double dz = point.dz + zi + JITTER_VECTORS_128[hash | 1];
            if ((dx - x) * (dx - x) + (dz - z) * (dz - z) < this.outerIslandBufferDistanceSq) continue;
            double falloff = 1.0 - (dx * dx + dz * dz) * (islandRadiusInverse * islandRadiusInverse);
            falloff = falloff < 0.0 ? 0.0 : (falloff *= falloff * falloff);
            value += falloff;
        }
        if ((value = value * 200.0 + -100.0) > 80.0) {
            value = 80.0;
        }
        return value;
    }

    static {
        for (int i = 0; i < JITTER_VECTORS_128.length; ++i) {
            int n = i;
            JITTER_VECTORS_128[n] = JITTER_VECTORS_128[n] * JITTER_AMOUNT;
            MetaballEndIslandNoise.REMAINING_HASH_LOOKUP[i] = i > 240 ? 10 : (i & 1) + i / 48 * 2;
        }
        INSTANCE = new MetaballEndIslandNoise(100.0, 38.0, 89.0, 1024, 0.004);
    }

    static class LatticePoint {
        public int xsv;
        public int zsv;
        public double dx;
        public double dz;

        public LatticePoint(int xsv, int zsv) {
            System.out.println(xsv + "," + zsv);
            this.xsv = xsv;
            this.zsv = zsv;
            double t = (double)(xsv + zsv) * -0.211324865405187;
            this.dx = -((double)xsv + t);
            this.dz = -((double)zsv + t);
        }
    }
}

