/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.util.noise;

import java.util.Random;

public class NeoNotchNoise {
    private static final int PSIZE = 2048;
    private static final int PMASK = 2047;
    private short[] perm = new short[2048];
    public static final double N3 = 2.742445288166158;
    private static final double[] GRADIENTS_3D;

    public NeoNotchNoise(long seed) {
        int i;
        short[] source = new short[2048];
        for (i = 0; i < 2048; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 2047; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            source[r] = source[i];
        }
    }

    public NeoNotchNoise(Random rand) {
        int i;
        short[] source = new short[2048];
        for (i = 0; i < 2048; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        for (i = 2047; i >= 0; --i) {
            int r = rand.nextInt(i + 1);
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            source[r] = source[i];
        }
    }

    public double noise3(double x, double y, double z, double shelfSmoothFactor) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        int xrb = NeoNotchNoise.fastFloor(xr);
        int yrb = NeoNotchNoise.fastFloor(yr);
        int zrb = NeoNotchNoise.fastFloor(zr);
        double xri = xr - (double)xrb;
        double yri = yr - (double)yrb;
        double zri = zr - (double)zrb;
        double inverseShelfSmoothFactor = 1.0 / shelfSmoothFactor;
        double g000 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb & 0x7FF] ^ yrb & 0x7FF] ^ zrb & 0x7FF] << 2, xri, yri, zri, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g001 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb & 0x7FF] ^ yrb & 0x7FF] ^ zrb + 1 & 0x7FF] << 2, xri, yri, zri - 1.0, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g010 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb & 0x7FF] ^ yrb + 1 & 0x7FF] ^ zrb & 0x7FF] << 2, xri, yri - 1.0, zri, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g011 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb & 0x7FF] ^ yrb + 1 & 0x7FF] ^ zrb + 1 & 0x7FF] << 2, xri, yri - 1.0, zri - 1.0, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g100 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb + 1 & 0x7FF] ^ yrb & 0x7FF] ^ zrb & 0x7FF] << 2, xri - 1.0, yri, zri, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g101 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb + 1 & 0x7FF] ^ yrb & 0x7FF] ^ zrb + 1 & 0x7FF] << 2, xri - 1.0, yri, zri - 1.0, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g110 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb + 1 & 0x7FF] ^ yrb + 1 & 0x7FF] ^ zrb & 0x7FF] << 2, xri - 1.0, yri - 1.0, zri, shelfSmoothFactor, inverseShelfSmoothFactor);
        double g111 = NeoNotchNoise.grad3(this.perm[this.perm[this.perm[xrb + 1 & 0x7FF] ^ yrb + 1 & 0x7FF] ^ zrb + 1 & 0x7FF] << 2, xri - 1.0, yri - 1.0, zri - 1.0, shelfSmoothFactor, inverseShelfSmoothFactor);
        double fadeX = NeoNotchNoise.fadeCurve(xri);
        double fadeY = NeoNotchNoise.fadeCurve(yri);
        double fadeZ = NeoNotchNoise.fadeCurve(zri);
        double g00Z = (1.0 - fadeZ) * g000 + fadeZ * g001;
        double g01Z = (1.0 - fadeZ) * g010 + fadeZ * g011;
        double g10Z = (1.0 - fadeZ) * g100 + fadeZ * g101;
        double g11Z = (1.0 - fadeZ) * g110 + fadeZ * g111;
        double g0YZ = (1.0 - fadeY) * g00Z + fadeY * g01Z;
        double g1YZ = (1.0 - fadeY) * g10Z + fadeY * g11Z;
        double gXYZ = (1.0 - fadeX) * g0YZ + fadeX * g1YZ;
        return gXYZ;
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    private static double grad3(int index, double dx, double dy, double dz, double shelfSmoothFactor, double inverseShelfSmoothFactor) {
        double toShelf = dx + dy + dz + GRADIENTS_3D[index | 3];
        if (toShelf - shelfSmoothFactor > 0.0) {
            return 0.0;
        }
        double value = GRADIENTS_3D[index | 0] * dx + GRADIENTS_3D[index | 1] * dy + GRADIENTS_3D[index | 2] * dz;
        if (toShelf + shelfSmoothFactor > 0.0) {
            value *= NeoNotchNoise.shelfFadeCurve(toShelf * inverseShelfSmoothFactor);
        }
        return value;
    }

    private static double fadeCurve(double t) {
        return t * t * t * (10.0 + t * (-15.0 + t * 6.0));
    }

    private static double shelfFadeCurve(double t) {
        return 0.5 + t * (-0.9375 + t * t * (0.625 + t * t * -0.1875));
    }

    static {
        double[] grad3 = new double[]{-2.22474487139, -2.22474487139, -1.0, 0.0, -2.22474487139, -2.22474487139, 1.0, 0.0, -3.0862664687972017, -1.1721513422464978, 0.0, 0.0, -1.1721513422464978, -3.0862664687972017, 0.0, 0.0, -2.22474487139, -1.0, -2.22474487139, 0.0, -2.22474487139, 1.0, -2.22474487139, 0.0, -1.1721513422464978, 0.0, -3.0862664687972017, 0.0, -3.0862664687972017, 0.0, -1.1721513422464978, 0.0, -2.22474487139, -1.0, 2.22474487139, 0.0, -2.22474487139, 1.0, 2.22474487139, 0.0, -3.0862664687972017, 0.0, 1.1721513422464978, 0.0, -1.1721513422464978, 0.0, 3.0862664687972017, 0.0, -2.22474487139, 2.22474487139, -1.0, 0.0, -2.22474487139, 2.22474487139, 1.0, 0.0, -1.1721513422464978, 3.0862664687972017, 0.0, 0.0, -3.0862664687972017, 1.1721513422464978, 0.0, 0.0, -1.0, -2.22474487139, -2.22474487139, 0.0, 1.0, -2.22474487139, -2.22474487139, 0.0, 0.0, -3.0862664687972017, -1.1721513422464978, 0.0, 0.0, -1.1721513422464978, -3.0862664687972017, 0.0, -1.0, -2.22474487139, 2.22474487139, 0.0, 1.0, -2.22474487139, 2.22474487139, 0.0, 0.0, -1.1721513422464978, 3.0862664687972017, 0.0, 0.0, -3.0862664687972017, 1.1721513422464978, 0.0, -1.0, 2.22474487139, -2.22474487139, 0.0, 1.0, 2.22474487139, -2.22474487139, 0.0, 0.0, 1.1721513422464978, -3.0862664687972017, 0.0, 0.0, 3.0862664687972017, -1.1721513422464978, 0.0, -1.0, 2.22474487139, 2.22474487139, 0.0, 1.0, 2.22474487139, 2.22474487139, 0.0, 0.0, 3.0862664687972017, 1.1721513422464978, 0.0, 0.0, 1.1721513422464978, 3.0862664687972017, 0.0, 2.22474487139, -2.22474487139, -1.0, 0.0, 2.22474487139, -2.22474487139, 1.0, 0.0, 1.1721513422464978, -3.0862664687972017, 0.0, 0.0, 3.0862664687972017, -1.1721513422464978, 0.0, 0.0, 2.22474487139, -1.0, -2.22474487139, 0.0, 2.22474487139, 1.0, -2.22474487139, 0.0, 3.0862664687972017, 0.0, -1.1721513422464978, 0.0, 1.1721513422464978, 0.0, -3.0862664687972017, 0.0, 2.22474487139, -1.0, 2.22474487139, 0.0, 2.22474487139, 1.0, 2.22474487139, 0.0, 1.1721513422464978, 0.0, 3.0862664687972017, 0.0, 3.0862664687972017, 0.0, 1.1721513422464978, 0.0, 2.22474487139, 2.22474487139, -1.0, 0.0, 2.22474487139, 2.22474487139, 1.0, 0.0, 3.0862664687972017, 1.1721513422464978, 0.0, 0.0, 1.1721513422464978, 3.0862664687972017, 0.0, 0.0};
        int nGrad3 = grad3.length / 4;
        GRADIENTS_3D = new double[8192];
        int i = 0;
        while (i < grad3.length) {
            int n = i++;
            grad3[n] = grad3[n] / 2.742445288166158;
        }
        for (i = 0; i < 2048; ++i) {
            double j = i / nGrad3;
            double shelfOffset = j > 24.0 ? Double.NEGATIVE_INFINITY : -j / 24.0;
            int grad3Index = i % nGrad3 * 4;
            NeoNotchNoise.GRADIENTS_3D[i * 4 + 0] = grad3[grad3Index + 0];
            NeoNotchNoise.GRADIENTS_3D[i * 4 + 1] = grad3[grad3Index + 1];
            NeoNotchNoise.GRADIENTS_3D[i * 4 + 2] = grad3[grad3Index + 2];
            NeoNotchNoise.GRADIENTS_3D[i * 4 + 3] = shelfOffset;
        }
    }
}

