/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.util.noise.pointgathering;

import java.util.List;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.GatheredPoint;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.UnfilteredPointGatherer;

public class ChunkPointGatherer<TTag> {
    private static final double CHUNK_RADIUS_RATIO = Math.sqrt(0.5);
    int halfChunkWidth;
    double maxPointContributionRadius;
    double maxPointContributionRadiusSq;
    double radiusPlusHalfChunkWidth;
    UnfilteredPointGatherer<TTag> unfilteredPointGatherer;

    public ChunkPointGatherer(double frequency, double maxPointContributionRadius, int chunkWidth) {
        this.halfChunkWidth = chunkWidth / 2;
        this.maxPointContributionRadius = maxPointContributionRadius;
        this.maxPointContributionRadiusSq = maxPointContributionRadius * maxPointContributionRadius;
        this.radiusPlusHalfChunkWidth = maxPointContributionRadius + (double)this.halfChunkWidth;
        this.unfilteredPointGatherer = new UnfilteredPointGatherer(frequency, maxPointContributionRadius + (double)chunkWidth * CHUNK_RADIUS_RATIO);
    }

    public List<GatheredPoint<TTag>> getPointsFromChunkBase(long seed, int chunkBaseWorldX, int chunkBaseWorldZ) {
        return this.getPointsFromChunkCenter(seed, chunkBaseWorldX + this.halfChunkWidth, chunkBaseWorldZ + this.halfChunkWidth);
    }

    public List<GatheredPoint<TTag>> getPointsFromChunkCenter(long seed, int chunkCenterWorldX, int chunkCenterWorldZ) {
        List<GatheredPoint<TTag>> worldPoints = this.unfilteredPointGatherer.getPoints(seed, chunkCenterWorldX, chunkCenterWorldZ);
        for (int i = 0; i < worldPoints.size(); ++i) {
            GatheredPoint<TTag> point = worldPoints.get(i);
            double axisCheckValueX = Math.abs(point.getX() - (double)chunkCenterWorldX) - (double)this.halfChunkWidth;
            double axisCheckValueZ = Math.abs(point.getZ() - (double)chunkCenterWorldZ) - (double)this.halfChunkWidth;
            if (!(axisCheckValueX >= this.maxPointContributionRadius) && !(axisCheckValueZ >= this.maxPointContributionRadius) && (!(axisCheckValueX > 0.0) || !(axisCheckValueZ > 0.0) || !(axisCheckValueX * axisCheckValueX + axisCheckValueZ * axisCheckValueZ >= this.maxPointContributionRadiusSq))) continue;
            int lastIndex = worldPoints.size() - 1;
            worldPoints.set(i, worldPoints.get(lastIndex));
            worldPoints.remove(lastIndex);
            --i;
        }
        return worldPoints;
    }
}

