/*
 * Decompiled with CFR 0.152.
 */
package jpg.k.simplyimprovedterrain.util.noise.pointgathering;

import java.util.ArrayList;
import java.util.List;
import jpg.k.simplyimprovedterrain.util.noise.pointgathering.GatheredPoint;

public class UnfilteredPointGatherer<TTag> {
    private static final double SQRT_HALF = Math.sqrt(0.5);
    private static final double TRIANGLE_EDGE_LENGTH = Math.sqrt(0.6666666666666666);
    private static final double TRIANGLE_HEIGHT = SQRT_HALF;
    private static final double INVERSE_TRIANGLE_HEIGHT = SQRT_HALF * 2.0;
    private static final double TRIANGLE_CIRCUMRADIUS = TRIANGLE_HEIGHT * 0.6666666666666666;
    private static final double JITTER_AMOUNT = TRIANGLE_HEIGHT;
    public static final double MAX_GRIDSCALE_DISTANCE_TO_CLOSEST_POINT = JITTER_AMOUNT + TRIANGLE_CIRCUMRADIUS;
    private static final int PRIME_X = 7691;
    private static final int PRIME_Z = 30869;
    private static final int JITTER_VECTOR_COUNT_MULTIPLIER_POWER = 1;
    private static final int JITTER_VECTOR_COUNT_MULTIPLIER = 2;
    private static final int N_VECTORS = 24;
    private static final int N_VECTORS_WITH_REPETITION = 32;
    private static final int VECTOR_INDEX_MASK = 31;
    private static final int JITTER_SINCOS_OFFSET = 8;
    private static double[] JITTER_SINCOS;
    private final double frequency;
    private final double inverseFrequency;
    private final LatticePoint[] pointsToSearch;

    public UnfilteredPointGatherer(double frequency, double maxPointContributionRadius) {
        this.frequency = frequency;
        this.inverseFrequency = 1.0 / frequency;
        double maxContributingDistance = maxPointContributionRadius * frequency + MAX_GRIDSCALE_DISTANCE_TO_CLOSEST_POINT;
        double maxContributingDistanceSq = maxContributingDistance * maxContributingDistance;
        double latticeSearchRadius = maxContributingDistance * INVERSE_TRIANGLE_HEIGHT;
        ArrayList<LatticePoint> pointsToSearchList = new ArrayList<LatticePoint>();
        pointsToSearchList.add(new LatticePoint(0, 0));
        int i = 1;
        while ((double)i < latticeSearchRadius) {
            LatticePoint point;
            int zsv;
            int xsv = i;
            for (zsv = 0; zsv < i; ++zsv) {
                point = new LatticePoint(xsv, zsv);
                if (!(point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq)) continue;
                pointsToSearchList.add(point);
            }
            while (xsv > 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --xsv;
            }
            while (xsv > -i) {
                point = new LatticePoint(xsv, zsv);
                if (point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --xsv;
                --zsv;
            }
            while (zsv > -i) {
                point = new LatticePoint(xsv, zsv);
                if (point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                --zsv;
            }
            while (xsv < 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                ++xsv;
            }
            while (zsv < 0) {
                point = new LatticePoint(xsv, zsv);
                if (point.xv * point.xv + point.zv * point.zv < maxContributingDistanceSq) {
                    pointsToSearchList.add(point);
                }
                ++xsv;
                ++zsv;
            }
            ++i;
        }
        this.pointsToSearch = pointsToSearchList.toArray(new LatticePoint[0]);
    }

    public List<GatheredPoint<TTag>> getPoints(long seed, double x, double z) {
        int zsb;
        double s = ((x *= this.frequency) + (z *= this.frequency)) * 0.366025403784439;
        double xs = x + s;
        double zs = z + s;
        int xsb = (int)xs;
        if (xs < (double)xsb) {
            --xsb;
        }
        if (zs < (double)(zsb = (int)zs)) {
            --zsb;
        }
        double xsi = xs - (double)xsb;
        double zsi = zs - (double)zsb;
        double p = 2.0 * xsi - zsi;
        double q = 2.0 * zsi - xsi;
        double r = xsi + zsi;
        if (r > 1.0) {
            if (p < 0.0) {
                ++zsb;
            } else if (q < 0.0) {
                ++xsb;
            } else {
                ++xsb;
                ++zsb;
            }
        } else if (p > 1.0) {
            ++xsb;
        } else if (q > 1.0) {
            ++zsb;
        }
        int xsbp = xsb * 7691;
        int zsbp = zsb * 30869;
        double bt = (double)(xsb + zsb) * -0.211324865405187;
        double xb = (double)xsb + bt;
        double zb = (double)zsb + bt;
        ArrayList<GatheredPoint<TTag>> worldPointsList = new ArrayList<GatheredPoint<TTag>>(this.pointsToSearch.length);
        for (int i = 0; i < this.pointsToSearch.length; ++i) {
            LatticePoint point = this.pointsToSearch[i];
            int xsvp = xsbp + point.xsvp;
            int zsvp = zsbp + point.zsvp;
            int hash = xsvp ^ zsvp;
            hash = ((int)(seed & 0xFFFFFFFFL) ^ hash) * 668908897 ^ ((int)(seed >> 32) ^ hash) * 35311;
            int indexBase = (hash & 0x3FFFFFF) * 0x5555555;
            int index = indexBase >> 26 & 0x1F;
            int remainingHash = indexBase & 0x3FFFFFF;
            double scaledX = xb + point.xv + JITTER_SINCOS[index];
            double scaledZ = zb + point.zv + JITTER_SINCOS[index + 8];
            GatheredPoint worldPoint = new GatheredPoint(scaledX * this.inverseFrequency, scaledZ * this.inverseFrequency, remainingHash);
            worldPointsList.add(worldPoint);
        }
        return worldPointsList;
    }

    static {
        int sinCosArraySize = 40;
        double sinCosOffsetFactor = 0.5;
        JITTER_SINCOS = new double[40];
        int j = 0;
        for (int i = 0; i < 24; ++i) {
            UnfilteredPointGatherer.JITTER_SINCOS[j] = Math.sin(((double)i + 0.5) * 0.2617993877991494) * JITTER_AMOUNT;
            if ((++j & 3) != 1) continue;
            UnfilteredPointGatherer.JITTER_SINCOS[j] = JITTER_SINCOS[j - 1];
            ++j;
        }
        for (int j2 = 32; j2 < 40; ++j2) {
            UnfilteredPointGatherer.JITTER_SINCOS[j2] = JITTER_SINCOS[j2 - 32];
        }
    }

    private static class LatticePoint {
        public int xsvp;
        public int zsvp;
        public double xv;
        public double zv;

        public LatticePoint(int xsv, int zsv) {
            this.xsvp = xsv * 7691;
            this.zsvp = zsv * 30869;
            double t = (double)(xsv + zsv) * -0.211324865405187;
            this.xv = (double)xsv + t;
            this.zv = (double)zsv + t;
        }
    }
}

