/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.WoodType;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import quek.undergarden.client.UndergardenClient;
import quek.undergarden.data.UGBlockStates;
import quek.undergarden.data.UGBlockTags;
import quek.undergarden.data.UGEntityTags;
import quek.undergarden.data.UGItemModels;
import quek.undergarden.data.UGItemTags;
import quek.undergarden.data.UGLang;
import quek.undergarden.data.UGLootTables;
import quek.undergarden.data.UGRecipes;
import quek.undergarden.entity.projectile.BlisterbombEntity;
import quek.undergarden.entity.projectile.GooBallEntity;
import quek.undergarden.entity.projectile.RottenBlisterberryEntity;
import quek.undergarden.entity.projectile.SlingshotAmmoEntity;
import quek.undergarden.item.UGSpawnEggItem;
import quek.undergarden.registry.UGBiomes;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGSurfaceBuilders;
import quek.undergarden.registry.UGTileEntities;
import quek.undergarden.registry.UGTreeDecoratorTypes;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";

    public Undergarden() {
        DeferredRegister[] registers;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, UGStructures::addDimensionalSpacing);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGBiomes.BIOMES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGEffects.EFFECTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructures.STRUCTURES, UGSurfaceBuilders.SURFACE_BUILDERS, UGTileEntities.TILE_ENTITIES, UGTreeDecoratorTypes.TREE_DECORATORS}) {
            register.register(bus);
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            UGEntityTypes.spawnPlacements();
            UGFeatures.registerConfiguredFeatures();
            UGCarvers.registerConfiguredCarvers();
            UGStructures.registerStructures();
            UGStructures.registerConfiguredStructures();
            UGCriteria.register();
            UGBiomes.toDictionary();
            UGDimensions.registerDimensionStuff();
            AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
            AxeItem.field_203176_a.put(UGBlocks.SMOGSTEM_LOG.get(), UGBlocks.STRIPPED_SMOGSTEM_LOG.get());
            AxeItem.field_203176_a.put(UGBlocks.SMOGSTEM_WOOD.get(), UGBlocks.STRIPPED_SMOGSTEM_WOOD.get());
            AxeItem.field_203176_a.put(UGBlocks.WIGGLEWOOD_LOG.get(), UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get());
            AxeItem.field_203176_a.put(UGBlocks.WIGGLEWOOD_WOOD.get(), UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get());
            AxeItem.field_203176_a.put(UGBlocks.GRONGLE_LOG.get(), UGBlocks.STRIPPED_GRONGLE_LOG.get());
            AxeItem.field_203176_a.put(UGBlocks.GRONGLE_WOOD.get(), UGBlocks.STRIPPED_GRONGLE_WOOD.get());
            HoeItem.field_195973_b.put(UGBlocks.DEEPTURF_BLOCK.get(), ((Block)UGBlocks.DEEPSOIL_FARMLAND.get()).func_176223_P());
            HoeItem.field_195973_b.put(UGBlocks.DEEPSOIL.get(), ((Block)UGBlocks.DEEPSOIL_FARMLAND.get()).func_176223_P());
            HoeItem.field_195973_b.put(UGBlocks.COARSE_DEEPSOIL.get(), ((Block)UGBlocks.DEEPSOIL.get()).func_176223_P());
            DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    BucketItem bucketitem = (BucketItem)stack.func_77973_b();
                    BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
                    ServerWorld world = source.func_197524_h();
                    if (bucketitem.func_180616_a(null, (World)world, blockpos, null)) {
                        bucketitem.func_203792_a((World)world, stack, blockpos);
                        return new ItemStack((IItemProvider)Items.field_151133_ar);
                    }
                    return this.defaultBehavior.dispense(source, stack);
                }
            };
            DefaultDispenseItemBehavior eggBehavior = new DefaultDispenseItemBehavior(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    EntityType type = ((UGSpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                    type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                    stack.func_190918_g(1);
                    return stack;
                }
            };
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.VIRULENT_MIX_BUCKET.get()), (IDispenseItemBehavior)bucketBehavior);
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.GWIBLING_BUCKET.get()), (IDispenseItemBehavior)bucketBehavior);
            for (SpawnEggItem spawnEggItem : UGSpawnEggItem.UGEggs()) {
                DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)eggBehavior);
            }
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.DEPTHROCK_PEBBLE.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    return (ProjectileEntity)Util.func_200696_a((Object)((Object)new SlingshotAmmoEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), entity -> entity.func_213884_b(stackIn));
                }
            });
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.GOO_BALL.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    return (ProjectileEntity)Util.func_200696_a((Object)((Object)new GooBallEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), entity -> entity.func_213884_b(stackIn));
                }
            });
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.ROTTEN_BLISTERBERRY.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    return (ProjectileEntity)Util.func_200696_a((Object)((Object)new RottenBlisterberryEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), entity -> entity.func_213884_b(stackIn));
                }
            });
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)UGItems.BLISTERBOMB.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    return (ProjectileEntity)Util.func_200696_a((Object)((Object)new BlisterbombEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c())), entity -> entity.func_213884_b(stackIn));
                }
            });
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)((Block)UGBlocks.BLOOD_MUSHROOM_GLOBULE.get()).func_199767_j(), (Potion)((Potion)UGPotions.BRITTLENESS.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.field_151137_ax, (Potion)((Potion)UGPotions.LONG_BRITTLENESS.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.field_151114_aO, (Potion)((Potion)UGPotions.STRONG_BRITTLENESS.get()));
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)((Block)UGBlocks.VEIL_MUSHROOM.get()).func_199767_j(), (Potion)((Potion)UGPotions.FEATHERWEIGHT.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.field_151137_ax, (Potion)((Potion)UGPotions.LONG_FEATHERWEIGHT.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.field_151114_aO, (Potion)((Potion)UGPotions.STRONG_FEATHERWEIGHT.get()));
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)((StemGrownBlock)UGBlocks.GLOOMGOURD.get()).func_199767_j(), (Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()), (Item)Items.field_151137_ax, (Potion)((Potion)UGPotions.LONG_VIRULENT_RESISTANCE.get()));
            PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)((Item)UGItems.DROOPFRUIT.get()), (Potion)((Potion)UGPotions.GLOWING.get()));
            PotionBrewing.func_193357_a((Potion)((Potion)UGPotions.GLOWING.get()), (Item)Items.field_151137_ax, (Potion)((Potion)UGPotions.LONG_GLOWING.get()));
            ComposterBlock.func_220290_a((float)0.1f, (IItemProvider)((IItemProvider)UGItems.DROOPFRUIT.get()));
            ComposterBlock.func_220290_a((float)0.1f, (IItemProvider)((IItemProvider)UGItems.UNDERBEANS.get()));
            ComposterBlock.func_220290_a((float)0.2f, (IItemProvider)((IItemProvider)UGItems.BLISTERBERRY.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGItems.GLOOMGOURD_SEEDS.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGItems.GLOWING_KELP.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.SMOGSTEM_LEAVES.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.WIGGLEWOOD_LEAVES.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.GRONGLE_LEAVES.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.SMOGSTEM_SAPLING.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.WIGGLEWOOD_SAPLING.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.GRONGLE_SAPLING.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.DEEPTURF.get()));
            ComposterBlock.func_220290_a((float)0.3f, (IItemProvider)((IItemProvider)UGBlocks.SHIMMERWEED.get()));
            ComposterBlock.func_220290_a((float)0.5f, (IItemProvider)((IItemProvider)UGBlocks.TALL_DEEPTURF.get()));
            ComposterBlock.func_220290_a((float)0.5f, (IItemProvider)((IItemProvider)UGItems.DITCHBULB.get()));
            ComposterBlock.func_220290_a((float)0.5f, (IItemProvider)((IItemProvider)UGBlocks.TALL_SHIMMERWEED.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.VEIL_MUSHROOM.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.INK_MUSHROOM.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.GLOOMGOURD.get()));
            ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)UGBlocks.CARVED_GLOOMGOURD.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.INDIGO_MUSHROOM_CAP.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.INDIGO_MUSHROOM_STALK.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.VEIL_MUSHROOM_CAP.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.VEIL_MUSHROOM_STALK.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.INK_MUSHROOM_CAP.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.BLOOD_MUSHROOM_GLOBULE.get()));
            ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)UGBlocks.BLOOD_MUSHROOM_STALK.get()));
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.field_150457_bL;
            pot.addPlant(UGBlocks.SMOGSTEM_SAPLING.getId(), UGBlocks.POTTED_SMOGSTEM_SAPLING);
            pot.addPlant(UGBlocks.WIGGLEWOOD_SAPLING.getId(), UGBlocks.POTTED_WIGGLEWOOD_SAPLING);
            pot.addPlant(UGBlocks.SHIMMERWEED.getId(), UGBlocks.POTTED_SHIMMERWEED);
            pot.addPlant(UGBlocks.INDIGO_MUSHROOM.getId(), UGBlocks.POTTED_INDIGO_MUSHROOM);
            pot.addPlant(UGBlocks.VEIL_MUSHROOM.getId(), UGBlocks.POTTED_VEIL_MUSHROOM);
            pot.addPlant(UGBlocks.INK_MUSHROOM.getId(), UGBlocks.POTTED_INK_MUSHROOM);
            pot.addPlant(UGBlocks.BLOOD_MUSHROOM.getId(), UGBlocks.POTTED_BLOOD_MUSHROOM);
            pot.addPlant(UGBlocks.GRONGLE_SAPLING.getId(), UGBlocks.POTTED_GRONGLE_SAPLING);
            WoodType.func_227047_a_((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            WoodType.func_227047_a_((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            WoodType.func_227047_a_((WoodType)UGBlocks.GRONGLE_WOODTYPE);
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        UndergardenClient.registerBlockRenderers();
        UndergardenClient.registerEntityRenderers();
        UndergardenClient.registerBlockColors();
        UndergardenClient.registerItemColors();
        event.enqueueWork(() -> {
            Atlases.addWoodType((WoodType)UGBlocks.SMOGSTEM_WOODTYPE);
            Atlases.addWoodType((WoodType)UGBlocks.WIGGLEWOOD_WOODTYPE);
            Atlases.addWoodType((WoodType)UGBlocks.GRONGLE_WOODTYPE);
        });
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)UGTileEntities.UNDERGARDEN_SIGN.get()), SignTileEntityRenderer::new);
        ItemModelsProperties.func_239418_a_((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.func_184607_cu() != stack ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
        });
        ItemModelsProperties.func_239418_a_((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)UGItems.CLOGGRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
        DimensionRenderInfo.field_239208_a_.put((Object)UGDimensions.UNDERGARDEN_DIMENSION.func_240901_a_(), (Object)new DimensionRenderInfo(Float.NaN, false, DimensionRenderInfo.FogType.NONE, false, true){

            public Vector3d func_230494_a_(Vector3d vector3d, float sun) {
                return vector3d;
            }

            public boolean func_230493_a_(int x, int y) {
                return false;
            }
        });
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new UGBlockStates(generator, helper));
            generator.func_200390_a((IDataProvider)new UGItemModels(generator, helper));
            generator.func_200390_a((IDataProvider)new UGLang(generator));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new UGRecipes(generator));
            generator.func_200390_a((IDataProvider)new UGLootTables(generator));
            UGBlockTags blockTags = new UGBlockTags(generator, helper);
            generator.func_200390_a((IDataProvider)blockTags);
            generator.func_200390_a((IDataProvider)new UGItemTags(generator, blockTags, helper));
            generator.func_200390_a((IDataProvider)new UGEntityTags(generator, helper));
        }
    }
}

