/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.UGTeleporter;

public class UndergardenPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public UndergardenPortalBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(-1.0f).func_200942_a().func_235838_a_(state -> 10).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean trySpawnPortal(IWorld worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = this.isPortal(worldIn, pos);
        if (UndergardenPortalBlock$size != null && !UndergardenPortalBlock.onTrySpawnPortal(worldIn, pos, UndergardenPortalBlock$size)) {
            UndergardenPortalBlock$size.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(IWorld world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.func_180495_p(pos), size));
    }

    @Nullable
    public Size isPortal(IWorld worldIn, BlockPos pos) {
        Size UndergardenPortalBlock$size = new Size(worldIn, pos, Direction.Axis.X);
        if (UndergardenPortalBlock$size.isValid() && UndergardenPortalBlock$size.portalBlockCount == 0) {
            return UndergardenPortalBlock$size;
        }
        Size UndergardenPortalBlock$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        return UndergardenPortalBlock$size1.isValid() && UndergardenPortalBlock$size1.portalBlockCount == 0 ? UndergardenPortalBlock$size1 : null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1).validatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            } else {
                World entityWorld;
                if (!entity.field_70170_p.field_72995_K && !pos.equals((Object)entity.field_242271_ac)) {
                    entity.field_242271_ac = pos.func_185334_h();
                }
                if ((entityWorld = entity.field_70170_p) != null) {
                    ServerWorld destinationWorld;
                    RegistryKey<World> destination;
                    MinecraftServer minecraftserver = entityWorld.func_73046_m();
                    RegistryKey<World> registryKey = destination = entity.field_70170_p.func_234923_W_() == UGDimensions.UNDERGARDEN_WORLD ? World.field_234918_g_ : UGDimensions.UNDERGARDEN_WORLD;
                    if (minecraftserver != null && (destinationWorld = minecraftserver.func_71218_a(destination)) != null && minecraftserver.func_71255_r() && !entity.func_184218_aH()) {
                        entity.field_70170_p.func_217381_Z().func_76320_a("undergarden_portal");
                        entity.func_242279_ag();
                        entity.changeDimension(destinationWorld, (ITeleporter)new UGTeleporter(destinationWorld));
                        entity.field_70170_p.func_217381_Z().func_76319_b();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_AMBIENT.get(), SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!worldIn.func_180495_p(pos.func_177976_e()).func_203425_a((Block)this) && !worldIn.func_180495_p(pos.func_177974_f()).func_203425_a((Block)this)) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                xSpeed = rand.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                zSpeed = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)UGParticleTypes.UNDERGARDEN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
            this.world = worldIn;
            this.axis = axisIn;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.canConnect(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_203417_a(UGTags.Blocks.PORTAL_FRAME_BLOCKS); ++i) {
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            return this.world.func_180495_p(framePos).func_177230_c().func_203417_a(UGTags.Blocks.PORTAL_FRAME_BLOCKS) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == UGBlocks.UNDERGARDEN_PORTAL.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.world.func_180495_p(framePos = blockpos.func_177972_a(this.leftDir)).func_177230_c().func_203417_a(UGTags.Blocks.PORTAL_FRAME_BLOCKS) : i == this.width - 1 && !this.world.func_180495_p(framePos = blockpos.func_177972_a(this.rightDir)).func_177230_c().func_203417_a(UGTags.Blocks.PORTAL_FRAME_BLOCKS)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                if (this.world.func_180495_p(framePos).func_177230_c().func_203417_a(UGTags.Blocks.PORTAL_FRAME_BLOCKS)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == UGBlocks.UNDERGARDEN_PORTAL.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(IWorld world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

