/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.LocationCheck;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.DroopvineBlock;
import quek.undergarden.block.UGDoublePlantBlock;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.data.provider.UGBlockLootTableProvider;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGLootTables
extends LootTableProvider {
    private static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(net.minecraft.block.Blocks.field_150380_bt, net.minecraft.block.Blocks.field_150461_bJ, net.minecraft.block.Blocks.field_205165_jY, net.minecraft.block.Blocks.field_196703_eM, net.minecraft.block.Blocks.field_196705_eO, net.minecraft.block.Blocks.field_196710_eS, net.minecraft.block.Blocks.field_196708_eQ, net.minecraft.block.Blocks.field_196714_eU, net.minecraft.block.Blocks.field_196716_eW, net.minecraft.block.Blocks.field_204409_il, net.minecraft.block.Blocks.field_190975_dA, net.minecraft.block.Blocks.field_190988_dw, net.minecraft.block.Blocks.field_190989_dx, net.minecraft.block.Blocks.field_190986_du, net.minecraft.block.Blocks.field_190984_ds, net.minecraft.block.Blocks.field_190990_dy, net.minecraft.block.Blocks.field_190980_do, net.minecraft.block.Blocks.field_196875_ie, net.minecraft.block.Blocks.field_190982_dq, net.minecraft.block.Blocks.field_190979_dn, net.minecraft.block.Blocks.field_190978_dm, net.minecraft.block.Blocks.field_190983_dr, net.minecraft.block.Blocks.field_190987_dv, net.minecraft.block.Blocks.field_190991_dz, net.minecraft.block.Blocks.field_190977_dl, net.minecraft.block.Blocks.field_190981_dp).map(IItemProvider::func_199767_j).collect(ImmutableSet.toImmutableSet());
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public UGLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String func_200397_b() {
        return "Undergarden LootTables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(Entities::new, (Object)LootParameterSets.field_216263_d));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
    }

    private static LootTable.Builder droppingSeedsTall(Block originalBlock, Block newBlock) {
        LootEntry.Builder builder = ItemLootEntry.func_216168_a((IItemProvider)newBlock).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212840_b_(SHEARS);
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a(builder).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)originalBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)UGDoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER))).func_212840_b_(LocationCheck.func_241547_a_((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_235312_a_(BlockPredicate.Builder.func_226243_a_().func_233458_a_(originalBlock).func_233459_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)UGDoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).func_227196_b_()).func_226245_b_()), (BlockPos)new BlockPos(0, 1, 0)))).func_216040_a(LootPool.func_216096_a().func_216045_a(builder).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)originalBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)UGDoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER))).func_212840_b_(LocationCheck.func_241547_a_((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_235312_a_(BlockPredicate.Builder.func_226243_a_().func_233458_a_(originalBlock).func_233459_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)UGDoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).func_227196_b_()).func_226245_b_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)UGLootTables.withExplosionDecay((IItemProvider)stem, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)stemSeed).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.53333336f))))));
    }

    protected static <T> T withExplosionDecay(IItemProvider item, ILootFunctionConsumer<T> function) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.func_199767_j()) ? function.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : function.func_212862_c_());
    }

    public static class Entities
    extends EntityLootTables {
        protected void addTables() {
            this.func_218582_a((EntityType)UGEntityTypes.ROTLING.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.UTHERIC_SHARD.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
            this.func_218582_a((EntityType)UGEntityTypes.ROTWALKER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.UTHERIC_SHARD.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
            this.func_218582_a((EntityType)UGEntityTypes.ROTBEAST.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.UTHERIC_SHARD.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212840_b_(KilledByPlayer.func_215994_b()))));
            this.func_218582_a((EntityType)UGEntityTypes.DWELLER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.RAW_DWELLER_MEAT.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)field_218586_a))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.ROTDWELLER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.GWIBLING.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.RAW_GWIBLING.get())).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)field_218586_a)))).func_212840_b_(KilledByPlayer.func_215994_b())).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196106_bc)).func_212840_b_(RandomChance.func_216004_a((float)0.05f))));
            this.func_218582_a((EntityType)UGEntityTypes.BRUTE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.BRUTE_TUSK.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.SCINTLING.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.GOO_BALL.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.GLOOMPER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.RAW_GLOOMPER_LEG.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)field_218586_a))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.STONEBORN.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.DEPTHROCK_PEBBLE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.NARGOYLE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151007_F)).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))));
            this.func_218582_a((EntityType)UGEntityTypes.MUNCHER.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)3.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.CLOGGRUM_NUGGET.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.FROSTSTEEL_NUGGET.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.SPLOOGIE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.DEPTHROCK_PEBBLE.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.GWIB.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)UGEntityTypes.MASTICATOR.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.MASTICATOR_SCALES.get())).func_212840_b_(KilledByPlayer.func_215994_b())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)8.0f))))));
            this.func_218582_a((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.FORGOTTEN_NUGGET.get())).func_212840_b_(KilledByPlayer.func_215994_b())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)16.0f))))));
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return UGEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }

    public static class Blocks
    extends UGBlockLootTableProvider {
        protected void addTables() {
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEEPSOIL);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPSOIL_FARMLAND, (Supplier<? extends IItemProvider>)UGBlocks.DEEPSOIL);
            this.func_218507_a((Block)UGBlocks.UNDERBEAN_BUSH.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)UnderbeanBushBlock.AGE, 3))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.UNDERBEANS.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)UnderbeanBushBlock.AGE, 2))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.UNDERBEANS.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))));
            this.func_218507_a((Block)UGBlocks.BLISTERBERRY_BUSH.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlisterberryBushBlock.AGE, 3))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.BLISTERBERRY.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlisterberryBushBlock.AGE, 2))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.BLISTERBERRY.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlisterberryBushBlock.AGE, 3))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.ROTTEN_BLISTERBERRY.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)BlisterberryBushBlock.AGE, 2))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.ROTTEN_BLISTERBERRY.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))));
            this.func_218507_a((Block)UGBlocks.DITCHBULB_PLANT.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.DITCHBULB_PLANT.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)DitchbulbBlock.AGE, 1))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.DITCHBULB.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPTURF_BLOCK, (Supplier<? extends IItemProvider>)UGBlocks.DEEPSOIL);
            this.func_218522_a((Block)UGBlocks.TALL_DEEPTURF.get(), block -> UGLootTables.droppingSeedsTall(block, (Block)UGBlocks.DEEPTURF.get()));
            this.func_218522_a((Block)UGBlocks.TALL_SHIMMERWEED.get(), block -> UGLootTables.droppingSeedsTall(block, (Block)UGBlocks.SHIMMERWEED.get()));
            this.func_218522_a((Block)UGBlocks.DEEPTURF.get(), BlockLootTables::func_218486_d);
            this.func_218522_a((Block)UGBlocks.SHIMMERWEED.get(), BlockLootTables::func_218486_d);
            this.func_218522_a((Block)UGBlocks.ASHEN_DEEPTURF.get(), BlockLootTables::func_218486_d);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_LOG);
            this.dropWithFortune((Supplier<? extends Block>)UGBlocks.COAL_ORE, (IItemProvider)Items.field_151044_h);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_ORE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_ORE);
            this.dropWithFortune((Supplier<? extends Block>)UGBlocks.UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CHUNK);
            this.dropWithFortune((Supplier<? extends Block>)UGBlocks.OTHERSIDE_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CHUNK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.REGALIUM_ORE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SAPLING);
            this.func_218522_a((Block)UGBlocks.SMOGSTEM_LEAVES.get(), leaves -> Blocks.func_218540_a((Block)leaves, (Block)((Block)UGBlocks.SMOGSTEM_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SAPLING);
            this.func_218522_a((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), leaves -> Blocks.func_218540_a((Block)leaves, (Block)((Block)UGBlocks.WIGGLEWOOD_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218522_a((Block)UGBlocks.GRONGLE_LEAVES.get(), leaves -> Blocks.func_218540_a((Block)leaves, (Block)((Block)UGBlocks.GRONGLE_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CARVED_GLOOMGOURD);
            this.func_218522_a((Block)UGBlocks.DEPTHROCK_PEBBLES.get(), pebble -> Blocks.func_218530_a((Block)((Block)UGBlocks.DEPTHROCK_PEBBLES.get()), (IItemProvider)((IItemProvider)UGItems.DEPTHROCK_PEBBLE.get()), (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOM_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_BRICK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SMOGSTEM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.WIGGLEWOOD_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BARS);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLOWING_KELP, (IItemProvider)UGItems.GLOWING_KELP.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLOWING_KELP_PLANT, (IItemProvider)UGItems.GLOWING_KELP.get());
            this.func_218522_a((Block)UGBlocks.SMOGSTEM_DOOR.get(), block -> Blocks.func_218562_a((Block)block, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
            this.func_218522_a((Block)UGBlocks.WIGGLEWOOD_DOOR.get(), block -> Blocks.func_218562_a((Block)block, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_TRAPDOOR);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.SMOG_VENT, (Supplier<? extends IItemProvider>)UGBlocks.DEPTHROCK);
            this.func_218522_a((Block)UGBlocks.GOO.get(), bookshelf -> Blocks.func_218530_a((Block)bookshelf, (IItemProvider)((IItemProvider)UGItems.GOO_BALL.get()), (IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.ASHEN_DEEPTURF_BLOCK, (Supplier<? extends IItemProvider>)UGBlocks.DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WOOD);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SHARD_TORCH, (IItemProvider)UGItems.SHARD_TORCH.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.SHARD_WALL_TORCH, (IItemProvider)UGItems.SHARD_TORCH.get());
            this.func_218522_a((Block)UGBlocks.IRON_ORE.get(), block -> Blocks.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)Blocks.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_191525_da).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)6.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            this.func_218522_a((Block)UGBlocks.GOLD_ORE.get(), block -> Blocks.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)Blocks.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151074_bl).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)6.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
            this.dropWithFortune((Supplier<? extends Block>)UGBlocks.DIAMOND_ORE, (IItemProvider)Items.field_151045_i);
            this.func_218507_a((Block)UGBlocks.DROOPVINE.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)UGBlocks.DROOPVINE.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)DroopvineBlock.GLOWY, true))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)UGItems.DROOPFRUIT.get()))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.COARSE_DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SAPLING);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.GRONGLE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE_GATE);
            this.func_218522_a((Block)UGBlocks.GRONGLE_DOOR.get(), block -> Blocks.func_218562_a((Block)block, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_WOOD);
            this.func_218522_a((Block)UGBlocks.GLOOMGOURD_STEM.get(), stem -> Blocks.func_218475_b((Block)stem, (Item)((Item)UGItems.GLOOMGOURD_SEEDS.get())));
            this.func_218522_a((Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), stem -> UGLootTables.dropSeedsForStem(stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_SHIVERSTONE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_WALL);
            this.func_218522_a((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get(), mushroom -> Blocks.func_218491_c((Block)mushroom, (IItemProvider)((IItemProvider)UGBlocks.BLOOD_MUSHROOM.get())));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM_GLOBULE);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM_STALK);
            this.func_218522_a((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get(), mushroom -> Blocks.func_218491_c((Block)mushroom, (IItemProvider)((IItemProvider)UGBlocks.INDIGO_MUSHROOM.get())));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM_STALK);
            this.func_218522_a((Block)UGBlocks.VEIL_MUSHROOM_CAP.get(), mushroom -> Blocks.func_218491_c((Block)mushroom, (IItemProvider)((IItemProvider)UGBlocks.VEIL_MUSHROOM.get())));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM_STALK);
            this.func_218522_a((Block)UGBlocks.INK_MUSHROOM_CAP.get(), mushroom -> Blocks.func_218491_c((Block)mushroom, (IItemProvider)((IItemProvider)UGBlocks.INK_MUSHROOM.get())));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_SHIVERSTONE_BRICKS);
            this.func_218547_a((Block)UGBlocks.POTTED_SMOGSTEM_SAPLING.get());
            this.func_218547_a((Block)UGBlocks.POTTED_WIGGLEWOOD_SAPLING.get());
            this.func_218547_a((Block)UGBlocks.POTTED_SHIMMERWEED.get());
            this.func_218547_a((Block)UGBlocks.POTTED_INDIGO_MUSHROOM.get());
            this.func_218547_a((Block)UGBlocks.POTTED_VEIL_MUSHROOM.get());
            this.func_218547_a((Block)UGBlocks.POTTED_INK_MUSHROOM.get());
            this.func_218547_a((Block)UGBlocks.POTTED_BLOOD_MUSHROOM.get());
            this.func_218547_a((Block)UGBlocks.POTTED_GRONGLE_SAPLING.get());
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.FROZEN_DEEPTURF_BLOCK, (Supplier<? extends IItemProvider>)UGBlocks.DEEPSOIL);
            this.func_218522_a((Block)UGBlocks.FROZEN_DEEPTURF.get(), BlockLootTables::func_218486_d);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_PRESSURE_PLATE);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SIGN, (IItemProvider)UGItems.SMOGSTEM_SIGN.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_SIGN, (IItemProvider)UGItems.SMOGSTEM_SIGN.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SIGN, (IItemProvider)UGItems.WIGGLEWOOD_SIGN.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_SIGN, (IItemProvider)UGItems.WIGGLEWOOD_SIGN.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_SIGN, (IItemProvider)UGItems.GRONGLE_SIGN.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_SIGN, (IItemProvider)UGItems.GRONGLE_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GOO_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SEDIMENT);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS_PANE);
        }

        protected Iterable<Block> getKnownBlocks() {
            return UGBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

