/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(UGBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public UGBoatEntity(EntityType<? extends BoatEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public UGBoatEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends BoatEntity>)((EntityType)UGEntityTypes.BOAT.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public Type getUGBoatType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    public Item func_184455_j() {
        switch (this.getUGBoatType()) {
            default: {
                return (Item)UGItems.SMOGSTEM_BOAT.get();
            }
            case WIGGLEWOOD: {
                return (Item)UGItems.WIGGLEWOOD_BOAT.get();
            }
            case GRONGLE: 
        }
        return (Item)UGItems.GRONGLE_BOAT.get();
    }

    public void setBoatType(Type boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)Type.SMOGSTEM.ordinal());
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getUGBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        SMOGSTEM((Block)UGBlocks.SMOGSTEM_PLANKS.get(), "smogstem"),
        WIGGLEWOOD((Block)UGBlocks.WIGGLEWOOD_PLANKS.get(), "wigglewood"),
        GRONGLE((Block)UGBlocks.GRONGLE_PLANKS.get(), "grongle");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aUGBoatEntity$type = Type.values();
            if (id < 0 || id >= aUGBoatEntity$type.length) {
                id = 0;
            }
            return aUGBoatEntity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] boatTypeArray;
            for (Type type : boatTypeArray = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return boatTypeArray[0];
        }
    }
}

