/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.cavern;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import quek.undergarden.entity.cavern.AbstractCavernCreatureEntity;
import quek.undergarden.registry.UGSoundEvents;

public class NargoyleEntity
extends AbstractCavernCreatureEntity {
    public NargoyleEntity(EntityType<? extends AbstractCavernCreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.2f));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 128.0);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.NARGOYLE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)UGSoundEvents.NARGOYLE_DEATH.get();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.func_184185_a((SoundEvent)UGSoundEvents.NARGOYLE_ATTACK.get(), 1.0f, 1.0f);
        return super.func_70652_k(entityIn);
    }

    public static class LeapAtTargetGoal
    extends Goal {
        private final MobEntity leaper;
        private LivingEntity leapTarget;
        private final float leapMotionY;

        public LeapAtTargetGoal(MobEntity leapingEntity, float leapMotionYIn) {
            this.leaper = leapingEntity;
            this.leapMotionY = leapMotionYIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.leaper.func_184207_aI()) {
                return false;
            }
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget == null) {
                return false;
            }
            double d0 = this.leaper.func_70068_e((Entity)this.leapTarget);
            if (!(d0 < 4.0) && !(d0 > 16.0)) {
                if (!this.leaper.func_233570_aj_()) {
                    return false;
                }
                return this.leaper.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.leaper.func_233570_aj_();
        }

        public void func_75249_e() {
            Vector3d vector3d = this.leaper.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(this.leapTarget.func_226277_ct_() - this.leaper.func_226277_ct_(), 0.0, this.leapTarget.func_226281_cx_() - this.leaper.func_226281_cx_());
            if (vector3d1.func_189985_c() > 1.0E-7) {
                vector3d1 = vector3d1.func_72432_b().func_186678_a(0.4).func_178787_e(vector3d.func_186678_a(0.2));
            }
            this.leaper.func_213293_j(vector3d1.field_72450_a * 2.0, (double)this.leapMotionY, vector3d1.field_72449_c * 2.0);
        }
    }
}

