/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import java.io.Serializable;
import me.hypherionmc.simplerpc.ClientEventHandler;
import me.hypherionmc.simplerpc.config.ConfigEngine;
import me.hypherionmc.simplerpc.config.confighandlers.RPCServerConfig;
import me.hypherionmc.simplerpc.network.ConfigPacket;
import me.hypherionmc.simplerpc.network.NetworkHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="simple-rpc")
public class SimpleRPC {
    private static RPCServerConfig serverConfig;
    private static RPCServerConfig lastServerConfig;

    public SimpleRPC() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> {
            ClientEventHandler clientEventHandler = new ClientEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
            clientEventHandler.commonSetup(event);
        });
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> (DistExecutor.SafeRunnable & Serializable)() -> MinecraftForge.EVENT_BUS.register((Object)this));
        NetworkHandler.registerMessages();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER) {
            try {
                if (serverConfig == null) {
                    lastServerConfig = serverConfig = ConfigEngine.initServerConfig(".", "en_us");
                }
                serverConfig = ConfigEngine.initServerConfig(".", "en_us");
                DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> (DistExecutor.SafeRunnable & Serializable)() -> {
                    if (!serverConfig.equals(lastServerConfig)) {
                        ConfigPacket packet = new ConfigPacket(serverConfig);
                        NetworkHandler.sendToAll(packet);
                        lastServerConfig = serverConfig;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

