/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import me.hypherionmc.simplerpc.config.confighandlers.RPCClientConfig;
import me.hypherionmc.simplerpc.config.confighandlers.RPCServerConfig;
import me.hypherionmc.simplerpc.discordutils.RPCEvents;
import me.hypherionmc.simplerpc.util.APIUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigEngine {
    private static final Logger LOGGER = LogManager.getLogger(ConfigEngine.class);
    public static String lngCode = "en_us";

    public static RPCClientConfig initConfig(String configPath, String langCode) {
        lngCode = langCode;
        RPCClientConfig config = null;
        File configFile = ConfigEngine.initTranslated(configPath, langCode);
        Gson gson = new Gson();
        InputStream in = ConfigEngine.class.getResourceAsStream("/simple-rpc.json");
        RPCClientConfig tmpConfig = (RPCClientConfig)gson.fromJson(APIUtils.readTextFile(in), RPCClientConfig.class);
        try {
            config = (RPCClientConfig)gson.fromJson((Reader)new FileReader(configFile), RPCClientConfig.class);
            if (tmpConfig != null && (tmpConfig.getVersion() > config.getVersion() || config.getVersion() == 0)) {
                config = APIUtils.migrateConfig(config, tmpConfig, configFile);
            }
        }
        catch (IOException e) {
            if (RPCEvents.getConfig().isDebugging()) {
                LOGGER.error("Could not load simple-rpc config file!");
            }
            e.printStackTrace();
        }
        if (config != null) {
            config.setConfigPath(configFile.getAbsolutePath());
        }
        return config;
    }

    private static File initDefault(String configPath) {
        File configFile = new File(configPath + "/config/simple-rpc.json");
        if (!configFile.exists()) {
            block4: {
                try {
                    InputStream in = ConfigEngine.class.getResourceAsStream("/simple-rpc.json");
                    Files.copy(in, configFile.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
                catch (Exception exception) {
                    if (!RPCEvents.getConfig().isDebugging()) break block4;
                    LOGGER.error("Could not create config file. Please refer to the wiki");
                }
            }
            if (RPCEvents.getConfig().isDebugging()) {
                LOGGER.warn("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
            }
        }
        return configFile;
    }

    private static File initTranslated(String configPath, String langCode) {
        File configFile;
        File langDir = new File(configPath + "/simple-rpc/");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        if (!(configFile = new File(langDir + "/simple-rpc_" + langCode + ".json")).exists()) {
            configFile = ConfigEngine.initDefault(configPath);
        }
        return configFile;
    }

    public static RPCServerConfig initServerConfig(String configPath, String langCode) {
        lngCode = langCode;
        RPCServerConfig config = null;
        File configFile = ConfigEngine.initServerDefault(configPath);
        Gson gson = new Gson();
        InputStream in = ConfigEngine.class.getResourceAsStream("/simple-rpc-server.json");
        RPCServerConfig tmpConfig = (RPCServerConfig)gson.fromJson(APIUtils.readTextFile(in), RPCServerConfig.class);
        try {
            config = (RPCServerConfig)gson.fromJson((Reader)new FileReader(configFile), RPCServerConfig.class);
            if (tmpConfig != null && (tmpConfig.getVersion() > config.getVersion() || config.getVersion() == 0)) {
                config = APIUtils.migrateServerConfig(config, tmpConfig, configFile);
            }
            if (config != null && config.getMulti_player() != null && config.getMulti_player().getDescription().equalsIgnoreCase("Playing on %server% (%ip) with %playercount% players")) {
                config.getMulti_player().setDescription("Playing on %servername% (%ip%) with %players% players");
            }
        }
        catch (IOException e) {
            if (RPCEvents.getConfig().isDebugging()) {
                LOGGER.error("Could not load simple-rpc config file!");
            }
            e.printStackTrace();
        }
        return config;
    }

    private static File initServerDefault(String configPath) {
        File configFile = new File(configPath + "/config/simple-rpc-server.json");
        if (!configFile.exists()) {
            block4: {
                try {
                    InputStream in = ConfigEngine.class.getResourceAsStream("/simple-rpc-server.json");
                    Files.copy(in, configFile.getAbsoluteFile().toPath(), new CopyOption[0]);
                }
                catch (Exception exception) {
                    if (!RPCEvents.getConfig().isDebugging()) break block4;
                    LOGGER.error("Could not create config file. Please refer to the wiki");
                }
            }
            if (RPCEvents.getConfig().isDebugging()) {
                LOGGER.warn("A config file has been created.\nPlease edit " + configFile.getAbsolutePath() + " to specify your RPC details");
            }
        }
        return configFile;
    }
}

