/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.discordutils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import me.hypherionmc.simplerpc.config.ConfigEngine;
import me.hypherionmc.simplerpc.config.confighandlers.RPCClientConfig;
import me.hypherionmc.simplerpc.config.confighandlers.RPCServerConfig;
import me.hypherionmc.simplerpc.config.jsonhelpers.RPCState;
import me.hypherionmc.simplerpc.discordutils.RPCBuild;
import me.hypherionmc.simplerpc.discordutils.RPCHandler;
import me.hypherionmc.simplerpc.util.IUtilHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RPCEvents {
    private static IUtilHandler utilHandler;
    private static String configPath;
    private static final Logger LOGGER;
    private static RPCClientConfig config;
    private static RPCClientConfig lastConfig;
    private static RPCHandler rpcHandler;
    private static RPCState rpcState;
    private static RPCState lastState;
    private static OffsetDateTime time;
    private static boolean isSingle;
    private static String langCode;
    private static Gson gson;
    private static boolean isServer;
    private static boolean isFirstJoin;
    private static RPCServerConfig serverConfig;

    public RPCEvents(IUtilHandler utilHandler, String path, String langCode) {
        RPCEvents.utilHandler = utilHandler;
        configPath = path;
        RPCEvents.langCode = langCode;
        config = ConfigEngine.initConfig(path, langCode);
        rpcHandler = new RPCHandler(config);
        this.initRPC();
        RPCEvents.runRPC();
    }

    public void initRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.INIT;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public static void runRPC() {
        RPCHandler.taskManager.scheduleAtFixedRate(() -> {
            config = ConfigEngine.initConfig(configPath, langCode);
            JsonElement element1 = gson.toJsonTree((Object)config);
            JsonElement element2 = gson.toJsonTree((Object)lastConfig);
            if (!(rpcState == RPCState.INIT || element1.toString().equalsIgnoreCase(element2.toString()) && lastState.equals((Object)rpcState))) {
                lastState = rpcState;
                lastConfig = config;
                RPCEvents.doRPCStuff();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    public void ingameRPC(boolean isSingle) {
        rpcState = RPCState.IN_GAME;
        RPCEvents.isSingle = isSingle;
        RPCEvents.doRPCStuff();
    }

    public void mainMenuRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.MAIN_MENU;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public void serverListRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.SERVER_MENU;
        isFirstJoin = true;
        RPCEvents.doRPCStuff();
    }

    public void joiningGameRPC() {
        time = OffsetDateTime.now();
        rpcState = RPCState.JOINING_GAME;
        RPCEvents.doRPCStuff();
    }

    public void joinGame() {
        if (isFirstJoin) {
            RPCBuild.offsetDateTime = OffsetDateTime.now();
            isFirstJoin = false;
        }
    }

    private static void doRPCStuff() {
        if (config != null && config.isEnabled()) {
            if (rpcState == RPCState.INIT) {
                if (config.getInit().isEnabled()) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getInit().getDescription())).setLargeImage(config.getInit().getLargeImageKey()).setLargeImageText(utilHandler.parseVars(config.getInit().getLargeImageText())).setSmallImage(config.getInit().getSmallImageKey()).setSmallImageText(utilHandler.parseVars(config.getInit().getSmallImageText())).setTimeStamp(time).setButtons(config.getInit().getButtonsList()).setState(utilHandler.parseVars(config.getInit().getState()));
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.MAIN_MENU) {
                if (rpcHandler != null) {
                    if (config.getMain_menu().isEnabled()) {
                        RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getMain_menu().getDescription())).setLargeImage(config.getMain_menu().getLargeImageKey()).setLargeImageText(utilHandler.parseVars(config.getMain_menu().getLargeImageText())).setSmallImage(config.getMain_menu().getSmallImageKey()).setSmallImageText(utilHandler.parseVars(config.getMain_menu().getSmallImageText())).setTimeStamp(time).setButtons(config.getMain_menu().getButtonsList()).setState(utilHandler.parseVars(config.getMain_menu().getState()));
                        rpcHandler.sendRPC(build.getPresence(false));
                    } else {
                        RPCEvents.genericRPC();
                    }
                }
            } else if (rpcState == RPCState.SERVER_MENU) {
                if (config.getServer_list().isEnabled()) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getServer_list().getDescription())).setLargeImage(config.getServer_list().getLargeImageKey()).setLargeImageText(utilHandler.parseVars(config.getServer_list().getLargeImageText())).setSmallImage(config.getServer_list().getSmallImageKey()).setSmallImageText(utilHandler.parseVars(config.getServer_list().getSmallImageText())).setTimeStamp(time).setButtons(config.getServer_list().getButtonsList()).setState(utilHandler.parseVars(config.getServer_list().getState()));
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.JOINING_GAME) {
                if (config.getJoin_game().isEnabled()) {
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getJoin_game().getDescription())).setLargeImage(config.getJoin_game().getLargeImageKey()).setLargeImageText(utilHandler.parseVars(config.getJoin_game().getLargeImageText())).setSmallImage(config.getJoin_game().getSmallImageKey()).setSmallImageText(utilHandler.parseVars(config.getJoin_game().getSmallImageText())).setTimeStamp(time).setButtons(config.getJoin_game().getButtonsList()).setState(utilHandler.parseVars(config.getJoin_game().getState()));
                    rpcHandler.sendRPC(build.getPresence(false));
                } else {
                    RPCEvents.genericRPC();
                }
            } else if (rpcState == RPCState.IN_GAME) {
                if (isSingle) {
                    if (config.getSingle_player().isEnabled()) {
                        if (rpcHandler != null) {
                            RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getSingle_player().getDescription()));
                            build.setLargeImage(config.getSingle_player().getLargeImageKey());
                            build.setLargeImageText(utilHandler.parseVars(config.getSingle_player().getLargeImageText()));
                            build.setSmallImage(config.getSingle_player().getSmallImageKey());
                            build.setSmallImageText(utilHandler.parseVars(config.getSingle_player().getSmallImageText()));
                            build.setState(utilHandler.parseVars(config.getSingle_player().getState()));
                            build.setButtons(config.getSingle_player().getButtonsList());
                            if (config.getWorld_images().isEnabled()) {
                                config.getWorld_images().getWorlds().stream().filter(world -> world.getWorldname().equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                                    if (worlds.getLargeImageKey() != null && !worlds.getLargeImageKey().isEmpty()) {
                                        build.setLargeImage(worlds.getLargeImageKey());
                                    }
                                    if (worlds.getLargeImageText() != null && !worlds.getLargeImageText().isEmpty()) {
                                        build.setLargeImageText(utilHandler.parseVars(worlds.getLargeImageText()));
                                    }
                                    if (worlds.getSmallImageKey() != null && !worlds.getSmallImageKey().isEmpty()) {
                                        build.setSmallImage(worlds.getSmallImageKey());
                                    }
                                    if (worlds.getSmallImageText() != null && !worlds.getSmallImageText().isEmpty()) {
                                        build.setSmallImageText(utilHandler.parseVars(worlds.getSmallImageText()));
                                    }
                                    return true;
                                });
                            }
                            rpcHandler.sendRPC(build.getPresence(true));
                        }
                    } else {
                        RPCEvents.genericRPC();
                    }
                } else if (config.getMulti_player().isEnabled()) {
                    RPCBuild finalBuild;
                    RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getMulti_player().getDescription()));
                    build.setLargeImage(config.getMulti_player().getLargeImageKey());
                    build.setLargeImageText(utilHandler.parseVars(config.getMulti_player().getLargeImageText()));
                    build.setSmallImage(config.getMulti_player().getSmallImageKey());
                    build.setSmallImageText(utilHandler.parseVars(config.getMulti_player().getSmallImageText()));
                    build.setState(utilHandler.parseVars(config.getMulti_player().getState()));
                    build.setButtons(config.getMulti_player().getButtonsList());
                    if (serverConfig != null && serverConfig.isEnabled() && serverConfig.getMulti_player().isEnabled()) {
                        build = new RPCBuild().setDetails(utilHandler.parseVars(serverConfig.getMulti_player().getDescription()));
                        build.setLargeImage(serverConfig.getMulti_player().getLargeImageKey());
                        build.setLargeImageText(utilHandler.parseVars(serverConfig.getMulti_player().getLargeImageText()));
                        build.setSmallImage(serverConfig.getMulti_player().getSmallImageKey());
                        build.setSmallImageText(utilHandler.parseVars(serverConfig.getMulti_player().getSmallImageText()));
                        build.setState(utilHandler.parseVars(serverConfig.getMulti_player().getState()));
                        build.setButtons(serverConfig.getMulti_player().getButtonsList());
                    }
                    if (config.getWorld_images().isEnabled()) {
                        finalBuild = build;
                        config.getWorld_images().getWorlds().stream().filter(world -> world.getWorldname().equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                            if (worlds.getLargeImageKey() != null && !worlds.getLargeImageKey().isEmpty()) {
                                finalBuild.setLargeImage(worlds.getLargeImageKey());
                            }
                            if (worlds.getLargeImageText() != null && !worlds.getLargeImageText().isEmpty()) {
                                finalBuild.setLargeImageText(utilHandler.parseVars(worlds.getLargeImageText()));
                            }
                            if (worlds.getSmallImageKey() != null && !worlds.getSmallImageKey().isEmpty()) {
                                finalBuild.setSmallImage(worlds.getSmallImageKey());
                            }
                            if (worlds.getSmallImageText() != null && !worlds.getSmallImageText().isEmpty()) {
                                finalBuild.setSmallImageText(utilHandler.parseVars(worlds.getSmallImageText()));
                            }
                            return true;
                        });
                    }
                    if (serverConfig != null && serverConfig.isEnabled() && serverConfig.getWorld_images().isEnabled()) {
                        finalBuild = build;
                        serverConfig.getWorld_images().getWorlds().stream().filter(world -> world.getWorldname().equalsIgnoreCase(utilHandler.getWorld())).anyMatch(worlds -> {
                            if (worlds.getLargeImageKey() != null && !worlds.getLargeImageKey().isEmpty()) {
                                finalBuild.setLargeImage(worlds.getLargeImageKey());
                            }
                            if (worlds.getLargeImageText() != null && !worlds.getLargeImageText().isEmpty()) {
                                finalBuild.setLargeImageText(utilHandler.parseVars(worlds.getLargeImageText()));
                            }
                            if (worlds.getSmallImageKey() != null && !worlds.getSmallImageKey().isEmpty()) {
                                finalBuild.setSmallImage(worlds.getSmallImageKey());
                            }
                            if (worlds.getSmallImageText() != null && !worlds.getSmallImageText().isEmpty()) {
                                finalBuild.setSmallImageText(utilHandler.parseVars(worlds.getSmallImageText()));
                            }
                            return true;
                        });
                        build = finalBuild;
                    }
                    rpcHandler.sendRPC(build.getPresence(true));
                } else {
                    RPCEvents.genericRPC();
                }
            } else {
                RPCEvents.genericRPC();
            }
        } else {
            rpcHandler.sendRPC(null);
        }
    }

    public static void genericRPC() {
        if (config != null && config.isEnabled() && rpcHandler != null) {
            RPCBuild build = new RPCBuild().setDetails(utilHandler.parseVars(config.getGeneric().getDescription())).setLargeImage(config.getGeneric().getLargeImageKey()).setLargeImageText(utilHandler.parseVars(config.getGeneric().getLargeImageText())).setSmallImage(config.getGeneric().getSmallImageKey()).setSmallImageText(utilHandler.parseVars(config.getGeneric().getSmallImageText())).setState(utilHandler.parseVars(config.getGeneric().getState())).setButtons(config.getGeneric().getButtonsList());
            rpcHandler.sendRPC(build.getPresence(false));
        }
    }

    public static void setServerData(RPCServerConfig serverData) {
        serverConfig = serverData;
        RPCEvents.doRPCStuff();
    }

    public void setLangCode(String langCode) {
        RPCEvents.langCode = langCode;
    }

    public static RPCClientConfig getConfig() {
        return config;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Simple RPC");
        lastState = RPCState.INIT;
        time = OffsetDateTime.now();
        isSingle = false;
        gson = new Gson();
        isServer = false;
        isFirstJoin = true;
    }
}

