/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBack;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookMarkRead;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBook
extends Screen {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static long lastSound;
    public int bookLeft;
    public int bookTop;
    private float scaleFactor;
    private List<ITextComponent> tooltip;
    private ItemStack tooltipStack;
    private Pair<BookEntry, Integer> targetPage;
    protected int spread = 0;
    protected int maxSpreads = 0;
    public int ticksInBook;
    public int maxScale;
    boolean needsBookmarkUpdate = false;

    public GuiBook(Book book, ITextComponent title) {
        super(title);
        this.book = book;
    }

    public void func_231160_c_() {
        MainWindow res = this.getMinecraft().func_228018_at_();
        double oldGuiScale = res.func_216521_a(this.getMinecraft().field_71474_y.field_74335_Z, this.getMinecraft().func_211821_e());
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        double newGuiScale = res.func_216521_a(persistentScale, this.getMinecraft().func_211821_e());
        if (persistentScale > 0 && newGuiScale != oldGuiScale) {
            this.scaleFactor = (float)newGuiScale / (float)res.func_198100_s();
            res.func_216525_a(newGuiScale);
            this.field_230708_k_ = res.func_198107_o();
            this.field_230709_l_ = res.func_198087_p();
            res.func_216525_a(oldGuiScale);
        } else {
            this.scaleFactor = 1.0f;
        }
        this.bookLeft = this.field_230708_k_ / 2 - 136;
        this.bookTop = this.field_230709_l_ / 2 - 90;
        this.book.contents.currentGui = this;
        this.func_230480_a_(new GuiButtonBookBack(this, this.field_230708_k_ / 2 - 9, this.bookTop + 180 - 5));
        this.func_230480_a_(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.func_230480_a_(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public final void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        ms.func_227860_a_();
        if (this.scaleFactor != 1.0f) {
            ms.func_227862_a_(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(ms, mouseX, mouseY, partialTicks);
        ms.func_227865_b_();
    }

    final void drawScreenAfterScale(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.func_230446_a_(ms);
        ms.func_227860_a_();
        ms.func_227861_a_((double)this.bookLeft, (double)this.bookTop, 0.0);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(ms, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(ms, mouseX, mouseY, partialTicks);
        ms.func_227865_b_();
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new BookDrawScreenEvent(this, this.book.id, mouseX, mouseY, partialTicks, ms));
        this.drawTooltip(ms, mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.removeButtonsIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : bookmarks) {
            this.func_230480_a_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        y += y == 0 ? 0 : 2;
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.func_230480_a_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.func_230480_a_(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 22, MultiblockVisualizationHandler.bookmark, true));
        }
        if (!this.shouldAddAddBookmarkButton() && this.book.contents.entries.values().stream().anyMatch(v -> !v.isLocked() && v.getReadState().equals((Object)EntryDisplayState.UNREAD))) {
            this.func_230480_a_(new GuiButtonBookMarkRead(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 10));
        }
    }

    public void removeButtonsIf(Predicate<IGuiEventListener> pred) {
        this.field_230710_m_.removeIf(pred);
        this.field_230705_e_.removeIf(pred);
    }

    public void removeButtonsIn(Collection<?> coll) {
        this.removeButtonsIf(coll::contains);
    }

    public <T extends Widget> T func_230480_a_(T widget) {
        return (T)super.func_230480_a_(widget);
    }

    public void func_238653_a_(MatrixStack matrices, @Nullable Style style, int mouseX, int mouseY) {
        super.func_238653_a_(matrices, style, mouseX, mouseY);
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void func_231023_e_() {
        if (!GuiBook.func_231173_s_()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(ms, this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(MatrixStack ms, int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.func_231151_a_(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.contents.getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getFirst())) {
                IFormattableTextComponent t = new StringTextComponent("(").func_230529_a_((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.shift_for_recipe")).func_240702_b_(")").func_240699_a_(TextFormatting.GOLD);
                tooltip.add(t);
                this.targetPage = provider;
            }
            GuiUtils.preItemToolTip((ItemStack)this.tooltipStack);
            this.func_243308_b(ms, tooltip, mouseX, mouseY);
            GuiUtils.postItemToolTip();
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.func_243308_b(ms, this.tooltip, mouseX, mouseY);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(MatrixStack ms, Book book, int x, int y, int u, int v, int w, int h) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.bookTexture);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public boolean func_231177_au__() {
        return this.book.pauseGame;
    }

    public void handleButtonBack(Button button) {
        this.back(false);
    }

    public void handleButtonArrow(Button button) {
        this.changePage(((GuiButtonBookArrow)button).left, false);
    }

    public void handleButtonBookmark(Button button) {
        GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
        PersistentData.DataHolder.BookData.Bookmark bookmark = bookmarkButton.bookmark;
        if (bookmark == null || bookmark.getEntry(this.book) == null) {
            this.bookmarkThis();
        } else if (GuiBook.func_231173_s_() && !bookmarkButton.multiblock) {
            List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
            bookmarks.remove(bookmark);
            PersistentData.save();
            this.needsBookmarkUpdate = true;
        } else {
            this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.page), true);
        }
    }

    public final boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return this.mouseClickedScaled(mouseX / (double)this.scaleFactor, mouseY / (double)this.scaleFactor, mouseButton);
    }

    public boolean mouseClickedScaled(double mouseX, double mouseY, int mouseButton) {
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.func_231173_s_()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getFirst(), (Integer)this.targetPage.getSecond()), true);
                GuiBook.playBookFlipSound(this.book);
                return true;
            }
            case 1: {
                this.back(true);
                return true;
            }
            case 3: {
                this.changePage(true, true);
                return true;
            }
            case 4: {
                this.changePage(false, true);
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            this.back(true);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.changePage(false, true);
        } else if (scroll > 0.0) {
            this.changePage(true, true);
        }
        return true;
    }

    void back(boolean sfx) {
        if (!this.book.contents.guiStack.isEmpty()) {
            if (GuiBook.func_231173_s_()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.contents.guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.contents.guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            this.spread = left ? --this.spread : ++this.spread;
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.spread > 0 : this.spread + 1 < this.maxSpreads;
    }

    public boolean canSeeBackButton() {
        return !this.book.contents.guiStack.isEmpty();
    }

    public void setTooltip(ITextComponent ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<ITextComponent> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(Collections.emptyList());
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(double absMx, double absMy, int x, int y, int w, int h) {
        double mx = this.getRelativeX(absMx);
        double my = this.getRelativeY(absMy);
        return mx > (double)x && my > (double)y && mx <= (double)(x + w) && my <= (double)(y + h);
    }

    public double getRelativeX(double absX) {
        return absX - (double)this.bookLeft;
    }

    public double getRelativeY(double absY) {
        return absY - (double)this.bookTop;
    }

    public void drawProgressBar(MatrixStack ms, Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || !book.advancementsEnabled()) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.contents.entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        AbstractGui.func_238467_a_((MatrixStack)ms, (int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(ms, barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.field_230712_o_.func_238422_b_(ms, new TranslationTextComponent("patchouli.gui.lexicon.progress_meter").func_241878_f(), (float)barLeft, (float)(barTop - 9), book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            TranslationTextComponent progressStr = new TranslationTextComponent("patchouli.gui.lexicon.progress_tooltip", new Object[]{unlockedEntries, totalEntries});
            tooltip.add((ITextComponent)progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.progress_tooltip.secret1").func_240699_a_(TextFormatting.GRAY));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.progress_tooltip.secret", new Object[]{unlockedSecretEntries}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add((ITextComponent)new TranslationTextComponent("patchouli.gui.lexicon.progress_tooltip.info").func_240699_a_(TextFormatting.GRAY));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(MatrixStack ms, int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.func_238468_a_(ms, x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(MatrixStack ms, IReorderingProcessor s, int x, int y, int color) {
        this.field_230712_o_.func_238422_b_(ms, s, (float)x - (float)this.field_230712_o_.func_243245_a(s) / 2.0f, (float)y, color);
    }

    public void drawCenteredStringNoShadow(MatrixStack ms, String s, int x, int y, int color) {
        this.field_230712_o_.func_238421_b_(ms, s, (float)x - (float)this.field_230712_o_.func_78256_a(s) / 2.0f, (float)y, color);
    }

    private int getMaxAllowedScale() {
        return this.getMinecraft().func_228018_at_().func_216521_a(0, this.getMinecraft().func_211821_e());
    }

    public int getSpread() {
        return this.spread;
    }

    public static void drawSeparator(MatrixStack ms, Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(ms, book, rx, y, 140, 180, w, h);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(MatrixStack ms, Book book, int x, int y) {
        GuiBook.drawFromTexture(ms, book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(MatrixStack ms, Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(ms, book, x, y, state.u, 197, 8, 8);
        RenderSystem.enableAlphaTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(MatrixStack ms, Book book) {
        GuiBook.drawPageFiller(ms, book, 141, 18);
    }

    public static void drawPageFiller(MatrixStack ms, Book book, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.fillerTexture);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6L) {
            SoundEvent sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.book_flip);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(String address) {
        Util.func_110647_a().func_195640_a(address);
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.contents.openLexiconGui(gui, push);
    }
}

