/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class OpenBookCommand {
    private static final SuggestionProvider<CommandSource> BOOK_ID_SUGGESTER = (ctx, builder) -> {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, Book> e : BookRegistry.INSTANCE.books.entrySet()) {
            if (e.getValue().isExtension) continue;
            ids.add(e.getKey());
        }
        return ISuggestionProvider.func_197014_a(ids, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> disp) {
        disp.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"open-patchouli-book").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"book", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(BOOK_ID_SUGGESTER).executes(ctx -> OpenBookCommand.doIt(EntityArgument.func_197090_e((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"book"), null, 0))).then(Commands.func_197056_a((String)"entry", (ArgumentType)ResourceLocationArgument.func_197197_a()).then(Commands.func_197056_a((String)"page", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> OpenBookCommand.doIt(EntityArgument.func_197090_e((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"book"), ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"entry"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))))));
    }

    private static int doIt(Collection<ServerPlayerEntity> players, ResourceLocation book, @Nullable ResourceLocation entry, int page) {
        for (ServerPlayerEntity player : players) {
            if (entry != null) {
                PatchouliAPI.get().openBookEntry(player, book, entry, page);
                continue;
            }
            PatchouliAPI.get().openBookGUI(player, book);
        }
        return players.size();
    }
}

