/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit;

import io.github.noeppi_noeppi.libx.annotation.PrimaryConstructor;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.GeneratedCodec;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModEnv;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.CodecType;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.FailureException;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.GetterSupplier;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.ParamType;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.RegistryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class CodecProcessor {
    public static final List<CodecType> CODECS = Collections.unmodifiableList(Arrays.asList(new RegistryType(), new ParamType()));

    public static void processParam(Element element, ModEnv env) {
        if (element.getEnclosingElement().getKind() != ElementKind.CONSTRUCTOR || element.getEnclosingElement().getAnnotation(PrimaryConstructor.class) == null) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@Param can only be used on parameters of the primary constructor.");
        }
    }

    public static void processPrimaryConstructor(Element rawElement, ModEnv env) {
        if (rawElement.getKind() != ElementKind.CONSTRUCTOR || !(rawElement instanceof ExecutableElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@PrimaryConstructor can only be used on constructors.", rawElement);
            return;
        }
        ExecutableElement element = (ExecutableElement)rawElement;
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Element annotated with @PrimaryConstructor is not a TypeElement.", element);
            return;
        }
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "The primary constructor of a class must be public.", element);
            return;
        }
        TypeElement type = (TypeElement)element.getEnclosingElement();
        if (type.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).filter(e -> e.getAnnotation(PrimaryConstructor.class) != null).count() >= 2L) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "A class can only have one primary constructor.", type);
            return;
        }
        if (element.getParameters().size() > 16) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "The primary constructor may not have more than 16 parameters. This is a limitation of DataFixerUpper.", type);
            return;
        }
        ArrayList<GeneratedCodec.CodecElement> params = new ArrayList<GeneratedCodec.CodecElement>();
        for (VariableElement variableElement : element.getParameters()) {
            String name = variableElement.getSimpleName().toString();
            StringBuilder sb = new StringBuilder();
            for (char chr : name.toCharArray()) {
                if (Character.isUpperCase(chr)) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(chr));
            }
            String codecFieldName = sb.toString();
            GetterSupplier getter = () -> {
                String g = CodecProcessor.getGetter((TypeElement)element.getEnclosingElement(), param.asType(), name, env);
                if (g == null) {
                    throw new FailureException();
                }
                return g;
            };
            CodecType codecType = null;
            for (CodecType c : CODECS) {
                if (!c.matchesDirect(variableElement, codecFieldName, env)) continue;
                if (codecType != null) {
                    env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't use multiple codec parameter annotations on the same element.", variableElement);
                    return;
                }
                codecType = c;
            }
            if (codecType == null) {
                for (CodecType c : CODECS) {
                    if (!c.matches(variableElement, codecFieldName, env)) continue;
                    codecType = c;
                    break;
                }
                if (codecType == null) {
                    env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't infer codec type for parameter. Add an explicit annotation.", variableElement);
                    return;
                }
            } else if (!codecType.matches(variableElement, codecFieldName, env)) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Parameter is not valid for applied annotation.", variableElement);
                return;
            }
            try {
                params.add(codecType.generate(variableElement, codecFieldName, getter, env));
            }
            catch (FailureException e2) {
                return;
            }
        }
        GeneratedCodec codec = new GeneratedCodec(type.getQualifiedName().toString(), params);
        env.getMod(element).addCodec(codec);
    }

    @Nullable
    private static String getGetter(TypeElement typeElem, TypeMirror type, String name, ModEnv env) {
        String elementFqn = typeElem.getQualifiedName().toString();
        VariableElement fieldElem = typeElem.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC)).filter(e -> e instanceof VariableElement).map(e -> (VariableElement)e).filter(e -> e.getSimpleName().contentEquals(name)).findFirst().orElse(null);
        if (fieldElem != null) {
            String getter = GeneratedCodec.fieldGetter(elementFqn, fieldElem.getSimpleName().toString());
            return CodecProcessor.withCheckType(getter, fieldElem.asType(), type, fieldElem, env);
        }
        ExecutableElement methodElem = CodecProcessor.getGetterMethod(typeElem, elementFqn, "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), env);
        if (methodElem == null && (methodElem = CodecProcessor.getGetterMethod(typeElem, elementFqn, name, env)) == null && env.unboxed(type).getKind() == TypeKind.BOOLEAN) {
            methodElem = CodecProcessor.getGetterMethod(typeElem, elementFqn, "is" + Character.toUpperCase(name.charAt(0)) + name.substring(1), env);
        }
        if (methodElem != null) {
            String getter = GeneratedCodec.methodGetter(elementFqn, methodElem.getSimpleName().toString());
            return CodecProcessor.withCheckType(getter, methodElem.getReturnType(), type, methodElem, env);
        }
        env.messager().printMessage(Diagnostic.Kind.ERROR, "Can't infer getter for parameter: Neither a public field / no-arg method named '" + name + "' nor a no no-arg method named 'get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "' found.", typeElem);
        return null;
    }

    @Nullable
    private static ExecutableElement getGetterMethod(TypeElement typeElem, String elementFqn, String methodName, ModEnv env) {
        return typeElem.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC)).filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> e.getSimpleName().contentEquals(methodName)).filter(e -> e.getParameters().isEmpty()).findFirst().orElse(null);
    }

    private static String withCheckType(String getter, TypeMirror got, TypeMirror expected, Element at, ModEnv env) {
        if (!env.types().isAssignable(got, expected)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Getter that was found for parameter has wrong type: " + got + " is not assignable to " + expected, at);
            return null;
        }
        return getter;
    }
}

